/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.tileentities.TileEntityColonyFlag;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemColonyFlagBanner
extends BannerItem {
    public ItemColonyFlagBanner(String name, Item.Properties properties) {
        this((Block)ModBlocks.blockColonyBanner, (Block)ModBlocks.blockColonyWallBanner, properties.stacksTo(1));
    }

    public ItemColonyFlagBanner(Block standingBanner, Block wallBanner, Item.Properties builder) {
        super(standingBanner, wallBanner, builder);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity te = context.getLevel().getBlockEntity(context.getClickedPos());
        ItemStack stack = context.getPlayer().getMainHandItem();
        if (te instanceof BannerBlockEntity || te instanceof TileEntityColonyFlag) {
            BannerPatternLayers bannerPatternLayers = te instanceof BannerBlockEntity ? ((BannerBlockEntity)te).getPatterns() : ((TileEntityColonyFlag)te).getPatterns();
            stack.set(DataComponents.BANNER_PATTERNS, (Object)bannerPatternLayers);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        if (tooltip.size() > 1) {
            tooltip.remove(1);
        }
    }
}

