/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.WindowClipBoard;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemClipboard
extends AbstractItemMinecolonies {
    public static final String TAG_COLONY = "colony";

    public ItemClipboard(Item.Properties properties) {
        super("clipboard", properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack clipboard = ctx.getPlayer().getItemInHand(ctx.getHand());
        BlockEntity entity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (entity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
            buildingEntity.writeColonyToItemStack(clipboard);
            if (!ctx.getLevel().isClientSide) {
                MessageUtils.format("com.minecolonies.coremod.item.clipboard.registered", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
            }
        } else if (ctx.getLevel().isClientSide) {
            ItemClipboard.openWindow(clipboard, ctx.getLevel(), ctx.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack clipboard = playerIn.getItemInHand(hand);
        if (!worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
        }
        ItemClipboard.openWindow(clipboard, worldIn, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
    }

    private static void openWindow(ItemStack stack, Level world, Player player) {
        IColonyView colonyView = ColonyId.readColonyViewFromItemStack(stack);
        if (colonyView != null) {
            new WindowClipBoard(colonyView).open();
        } else {
            player.displayClientMessage((Component)Component.translatableEscape((String)"com.minecolonies.coremod.item.clipboard.needcolony", (Object[])new Object[0]), true);
        }
    }
}

