/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.Utils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public abstract class CustomRecipeProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> providerFuture;
    protected HolderLookup.Provider provider;

    public CustomRecipeProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> providerFuture) {
        this.packOutput = packOutput;
        this.providerFuture = providerFuture;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.providerFuture.thenCompose(provider -> {
            this.provider = provider;
            PackOutput.PathProvider pathProvider = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "crafterrecipes");
            ArrayList futures = new ArrayList();
            HashSet dupeKeyCheck = new HashSet();
            this.registerRecipes(recipe -> {
                if (!dupeKeyCheck.add(recipe.id)) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipe.id));
                }
                futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)recipe.json, (Path)pathProvider.json(recipe.id)));
            });
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    protected CustomRecipeBuilder recipe(String crafter, String module, String id) {
        return new CustomRecipeBuilder(crafter, module, id, this.provider);
    }

    protected abstract void registerRecipes(@NotNull Consumer<CustomRecipeBuilder> var1);

    public static class CustomRecipeBuilder {
        private final HolderLookup.Provider provider;
        private final JsonObject json = new JsonObject();
        private final ResourceLocation id;
        private Block intermediate = Blocks.AIR;

        public CustomRecipeBuilder(String crafter, String module, String id, @NotNull HolderLookup.Provider provider) {
            this.provider = provider;
            this.json.addProperty("type", "recipe");
            this.json.addProperty("crafter", crafter + "_" + module);
            this.id = new ResourceLocation("minecolonies", crafter + "/" + id);
        }

        @NotNull
        public static CustomRecipeBuilder create(String crafter, String module, String id, @NotNull HolderLookup.Provider provider) {
            return new CustomRecipeBuilder(crafter, module, id, provider);
        }

        @NotNull
        public CustomRecipeBuilder inputs(@NotNull List<ItemStorage> inputs) {
            this.json.add("inputs", (JsonElement)this.storageAsJson(inputs));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder result(@NotNull ItemStack result) {
            JsonObject jsonItemStack = this.stackAsJson(result);
            this.json.add("result", (JsonElement)jsonItemStack);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder lootTable(@NotNull ResourceLocation lootTable) {
            this.json.addProperty("loot-table", lootTable.toString());
            return this;
        }

        @NotNull
        public CustomRecipeBuilder requiredTool(@NotNull EquipmentTypeEntry toolType) {
            if (toolType != ModEquipmentTypes.none.get()) {
                this.json.addProperty("tool", toolType.getRegistryName().toString());
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder secondaryOutputs(@NotNull List<ItemStack> secondary) {
            this.json.add("additional-output", (JsonElement)this.stackAsJson(secondary));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder alternateOutputs(@NotNull List<ItemStack> alternates) {
            this.json.add("alternate-output", (JsonElement)this.stackAsJson(alternates));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder intermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minResearchId(@NotNull ResourceLocation researchId) {
            JsonElement ids = this.json.get("research-id");
            if (ids == null) {
                this.json.addProperty("research-id", researchId.toString());
            } else if (ids.isJsonArray()) {
                ids.getAsJsonArray().add(researchId.toString());
            } else {
                JsonArray array = new JsonArray();
                array.add(ids.getAsString());
                array.add(researchId.toString());
                this.json.remove("research-id");
                this.json.add("research-id", (JsonElement)array);
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxResearchId(@NotNull ResourceLocation researchId) {
            JsonElement ids = this.json.get("not-research-id");
            if (ids == null) {
                this.json.addProperty("not-research-id", researchId.toString());
            } else if (ids.isJsonArray()) {
                ids.getAsJsonArray().add(researchId.toString());
            } else {
                JsonArray array = new JsonArray();
                array.add(ids.getAsString());
                array.add(researchId.toString());
                this.json.remove("not-research-id");
                this.json.add("not-research-id", (JsonElement)array);
            }
            return this;
        }

        @NotNull
        public CustomRecipeBuilder minBuildingLevel(int level) {
            this.json.addProperty("min-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder maxBuildingLevel(int level) {
            this.json.addProperty("max-building-level", (Number)level);
            return this;
        }

        @NotNull
        public CustomRecipeBuilder mustExist(boolean value) {
            this.json.addProperty("must-exist", Boolean.valueOf(value));
            return this;
        }

        @NotNull
        public CustomRecipeBuilder showTooltip(boolean value) {
            this.json.addProperty("show-tooltip", Boolean.valueOf(value));
            return this;
        }

        public void build(@NotNull Consumer<CustomRecipeBuilder> consumer) {
            this.json.addProperty("intermediate", BuiltInRegistries.BLOCK.getKey((Object)this.intermediate).toString());
            consumer.accept(this);
        }

        @NotNull
        private JsonObject stackAsJson(ItemStack stack) {
            JsonObject json = Utils.serializeCodecMessToJson(ItemStack.OPTIONAL_CODEC, this.provider, stack).getAsJsonObject();
            if (stack.getCount() == 1) {
                json.remove("count");
            }
            return json;
        }

        @NotNull
        private JsonArray stackAsJson(List<ItemStack> itemStacks) {
            JsonArray jsonItemStacks = new JsonArray();
            for (ItemStack itemStack : itemStacks) {
                jsonItemStacks.add((JsonElement)this.stackAsJson(itemStack));
            }
            return jsonItemStacks;
        }

        @NotNull
        private JsonArray storageAsJson(List<ItemStorage> itemStorages) {
            JsonArray jsonItemStorages = new JsonArray();
            for (ItemStorage itemStorage : itemStorages) {
                JsonObject jsonItemStorage = this.stackAsJson(itemStorage.getItemStack());
                if (itemStorage.getAmount() != 1) {
                    jsonItemStorage.addProperty("count", (Number)itemStorage.getAmount());
                }
                if (itemStorage.ignoreNBT()) {
                    jsonItemStorage.addProperty("matchType", "ignore");
                }
                jsonItemStorages.add((JsonElement)jsonItemStorage);
            }
            return jsonItemStorages;
        }
    }
}

