/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.ldtteam.blockui.AtlasManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="minecolonies", bus=EventBusSubscriber.Bus.MOD)
public class TextureReloadListener
extends SimplePreparableReloadListener<TexturePacks> {
    public static final List<String> TEXTURE_PACKS = new ArrayList<String>();

    @NotNull
    protected TexturePacks prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        HashSet<String> set = new HashSet<String>();
        ArrayList resLocs = new ArrayList(manager.listResources("textures/entity/citizen", f -> true).keySet());
        for (ResourceLocation res : resLocs) {
            String folder;
            if (!res.getPath().contains("png") || !res.getPath().contains("textures/entity/citizen") || (folder = res.getPath().split("/")[3]).isEmpty()) continue;
            set.add(folder);
        }
        TexturePacks packs = new TexturePacks();
        packs.packs = new ArrayList<String>(set);
        return packs;
    }

    protected void apply(@NotNull TexturePacks packs, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        TEXTURE_PACKS.clear();
        TEXTURE_PACKS.addAll(packs.packs);
    }

    @SubscribeEvent
    public static void modInitClient(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new TextureReloadListener());
        AtlasManager.INSTANCE.addAtlas(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0), "minecolonies");
    }

    public static class TexturePacks {
        public List<String> packs = new ArrayList<String>();
    }
}

