/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.interfaces.IRSComponentBlock;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ClientConfiguration;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.ChunkCapData;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.blocks.BlockScarecrow;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.blocks.huts.BlockHutTownHall;
import com.minecolonies.core.client.render.RenderBipedCitizen;
import com.minecolonies.core.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.core.colony.eventhooks.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.core.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobFarmer;
import com.minecolonies.core.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.core.commands.EntryPoint;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.EntityMercenary;
import com.minecolonies.core.items.ItemBannerRallyGuards;
import com.minecolonies.core.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.core.util.ChunkDataHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    private static Map<UUID, ChunkPos> playerPositions = new HashMap<UUID, ChunkPos>();

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAdded(@NotNull EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide()) {
            EntityCitizen citizen2;
            Entity entity;
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).mobAttackCitizens.get()).booleanValue() && event.getEntity() instanceof Mob && event.getEntity() instanceof Enemy && !event.getEntity().getType().is(ModTags.mobAttackBlacklist) && !(event.getEntity() instanceof AbstractFastMinecoloniesEntity)) {
                ((Mob)event.getEntity()).targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)event.getEntity(), EntityCitizen.class, true, citizen -> !citizen.isInvisible()));
                ((Mob)event.getEntity()).targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)event.getEntity(), EntityMercenary.class, true));
            }
            if (event.getEntity() instanceof AbstractFastMinecoloniesEntity && ((ServerLevel)event.getLevel()).getEntity(event.getEntity().getUUID()) != null) {
                event.setCanceled(true);
            }
            if ((entity = event.getEntity()) instanceof EntityCitizen && (citizen2 = (EntityCitizen)entity).getCitizenColonyHandler().getColonyId() == 0) {
                Log.getLogger().info("Prevented citizen with colony id 0 from joining world");
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(@NotNull LootTableLoadEvent event) {
        if (event.getName().equals((Object)BuiltInLootTables.SIMPLE_DUNGEON.location())) {
            LootPool.Builder pool = LootPool.lootPool();
            for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
                pool.add(LootItem.lootTableItem((ItemLike)crop).when(LootItemRandomChanceCondition.randomChance((float)0.005f)));
            }
            event.getTable().addPool(pool.build());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel) {
            ChunkDataHelper.loadChunk((LevelChunk)event.getChunk(), (ServerLevel)event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            ChunkDataHelper.unloadChunk((LevelChunk)event.getChunk(), (Level)((ServerLevel)event.getLevel()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        IColony oldColony;
        ServerPlayer player;
        LevelChunk oldChunk;
        int owningColony;
        if (event.getEntity() instanceof ServerPlayer && !event.isCanceled() && (owningColony = ColonyUtils.getOwningColony((ChunkAccess)(oldChunk = (player = (ServerPlayer)event.getEntity()).level().getChunk(player.chunkPosition().x, player.chunkPosition().z)))) != 0 && (oldColony = IColonyManager.getInstance().getColonyByWorld(owningColony, player.level())) != null) {
            oldColony.removeVisitingPlayer((Player)player);
            oldColony.getPackageManager().removeCloseSubscriber(player);
        }
    }

    @SubscribeEvent
    public static void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            LevelChunk newChunk = player.level().getChunk(player.chunkPosition().x, player.chunkPosition().z);
            IColony newColony = IColonyManager.getInstance().getColonyByWorld(ColonyUtils.getOwningColony((ChunkAccess)newChunk), player.level());
            if (newColony != null) {
                newColony.addVisitingPlayer((Player)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(PlayerTickEvent.Pre event) {
        IColony colony;
        ServerLevel world;
        block10: {
            block9: {
                Level level = event.getEntity().level();
                if (!(level instanceof ServerLevel)) break block9;
                world = (ServerLevel)level;
                if (event.getEntity().level().getGameTime() % 100L == 0L) break block10;
            }
            return;
        }
        ChunkPos chunkPos = event.getEntity().chunkPosition();
        ChunkPos oldPos = playerPositions.get(event.getEntity().getUUID());
        if (oldPos != null && oldPos.equals((Object)chunkPos)) {
            return;
        }
        playerPositions.put(event.getEntity().getUUID(), chunkPos);
        LevelChunk chunk = world.getChunk(chunkPos.x, chunkPos.z);
        if (chunk.isEmpty()) {
            return;
        }
        ChunkDataHelper.loadChunk(chunk, world);
        ChunkCapData chunkCapData = ColonyUtils.getChunkCapData((ChunkAccess)chunk);
        if (chunkCapData.getOwningColony() != -1 && (colony = IColonyManager.getInstance().getColonyByWorld(chunkCapData.getOwningColony(), (Level)world)) != null) {
            colony.addVisitingPlayer(event.getEntity());
            colony.getPackageManager().addCloseSubscriber((ServerPlayer)event.getEntity());
        }
        if (chunkCapData.getOwningColony() != 0) {
            for (Map.Entry<Integer, Set<BlockPos>> entry : chunkCapData.getAllClaimingBuildings().entrySet()) {
                IColony newColony = IColonyManager.getInstance().getColonyByWorld(entry.getKey(), (Level)world);
                if (newColony == null) continue;
                for (BlockPos buildingPos : entry.getValue()) {
                    IBuilding building = newColony.getBuildingManager().getBuilding(buildingPos);
                    if (building == null) continue;
                    building.onPlayerEnterNearby(event.getEntity());
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(MobSpawnEvent.PositionCheck event) {
        if (!(event.getEntity() instanceof Enemy) || !(event.getLevel() instanceof Level)) {
            return;
        }
        BlockPos pos = BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ());
        if (event.getSpawnType() == MobSpawnType.SPAWNER || event.getLevel().isClientSide() || !WorldUtil.isEntityBlockLoaded((LevelAccessor)event.getLevel(), pos)) {
            return;
        }
        LevelChunk chunk = ((Level)event.getLevel()).getChunkAt(pos);
        int owningColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (owningColony == 0) {
            return;
        }
        IColony newColony = IColonyManager.getInstance().getColonyByWorld(owningColony, (Level)event.getLevel());
        if (newColony == null) {
            return;
        }
        for (BlockPos buildingPos : ColonyUtils.getAllClaimingBuildings((ChunkAccess)chunk).getOrDefault(owningColony, Collections.emptySet())) {
            IBuilding building = newColony.getBuildingManager().getBuilding(buildingPos);
            if (building == null || building.getBuildingLevel() < 1 || !building.isInBuilding(pos)) continue;
            event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                if (!colony.getPermissions().hasPermission((Player)player, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY) && !colony.getPermissions().hasPermission((Player)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
                colony.getPackageManager().addImportantColonyPlayer(player);
                colony.getPackageManager().sendColonyViewPackets();
                colony.getPackageManager().sendPermissionsPackets();
            }
            int size = player.getInventory().getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!(stack.getItem() instanceof ItemBannerRallyGuards)) continue;
                ItemBannerRallyGuards.broadcastPlayerToRally(stack, player.level(), new EntityLocation(player.getUUID()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getPackageManager().removeCloseSubscriber(player);
                colony.getPackageManager().removeImportantColonyPlayer(player);
                playerPositions.remove(player.getUUID());
            }
        }
    }

    public static void onEnteringChunkEntity(@NotNull EntityCitizen entityCitizen, ChunkPos newChunkPos) {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue() && newChunkPos != null) {
            IColony colony;
            Level world;
            LevelChunk chunk;
            int owningColony;
            if (entityCitizen.level() == null || !WorldUtil.isEntityChunkLoaded((LevelAccessor)entityCitizen.level(), new ChunkPos(newChunkPos.x, newChunkPos.z))) {
                return;
            }
            if (entityCitizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && (owningColony = ColonyUtils.getOwningColony((ChunkAccess)(chunk = (world = entityCitizen.getCommandSenderWorld()).getChunk(newChunkPos.x, newChunkPos.z)))) != 0 && entityCitizen.getCitizenColonyHandler().getColonyId() != owningColony && (colony = IColonyManager.getInstance().getColonyByWorld(owningColony, entityCitizen.level())) != null) {
                colony.addGuardToAttackers(entityCitizen, ((IGuardBuilding)entityCitizen.getCitizenColonyHandler().getWorkBuilding()).getPlayerToFollowOrRally());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        BlockEntity spawner;
        if (event.getLevel().isClientSide() || !(event.getLevel() instanceof Level)) {
            return;
        }
        Level world = (Level)event.getLevel();
        if (event.getState().getBlock() instanceof SpawnerBlock && (spawner = event.getLevel().getBlockEntity(event.getPos())) instanceof SpawnerBlockEntity) {
            IColony colony;
            SpawnerBlockEntity spawnerBE = (SpawnerBlockEntity)spawner;
            if (spawnerBE.getSpawner().nextSpawnData != null && (colony = IColonyManager.getInstance().getColonyByDimension(spawnerBE.getSpawner().nextSpawnData.getEntityToSpawn().getInt("colony"), (ResourceKey<Level>)world.dimension())) != null) {
                colony.getEventManager().onTileEntityBreak(spawnerBE.getSpawner().nextSpawnData.getEntityToSpawn().getInt("mc_event_id"), spawner);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Block block;
        IColony colony;
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos bedBlockPos = event.getPos();
        if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.getBlockState(event.getPos()).getBlock() instanceof AbstractBlockHut) {
            IColony colony2 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony2 != null && !colony2.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
            }
            return;
        }
        if (world.getBlockState(event.getPos()).getBlock().isBed(world.getBlockState(event.getPos()), (BlockGetter)world, event.getPos(), (LivingEntity)player) && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, bedBlockPos)) != null && world.getBlockState(event.getPos()).hasProperty((Property)BedBlock.PART)) {
            List<ICitizenData> citizenList = colony.getCitizenManager().getCitizens();
            BlockState potentialBed = world.getBlockState(event.getPos());
            if (potentialBed.getBlock() instanceof BedBlock && potentialBed.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                bedBlockPos = bedBlockPos.relative((Direction)world.getBlockState(event.getPos()).getValue((Property)BedBlock.FACING));
            }
            for (ICitizenData citizen : citizenList) {
                if (!citizen.getBedPos().equals((Object)bedBlockPos) || !citizen.isAsleep()) continue;
                event.setCanceled(true);
                MessageUtils.format("block.minecraft.bed.occupied", new Object[0]).sendTo(player);
            }
        }
        EventHandler.handleEventCancellation(event, player);
        if (!event.isCanceled() && event.getEntity() instanceof Player && event.getItemStack().getItem() instanceof BlockItem && (block = ((BlockItem)event.getItemStack().getItem()).getBlock()) instanceof AbstractBlockHut && !(block instanceof IRSComponentBlock)) {
            IColony colony3 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony3 != null && !colony3.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
                return;
            }
            if (!player.isCreative() || !player.isShiftKeyDown()) {
                ItemStack stack = event.getItemStack();
                if (!stack.isEmpty() && !world.isClientSide) {
                    new OpenSuggestionWindowMessage((BlockState)block.defaultBlockState().setValue((Property)AbstractBlockHut.FACING, (Comparable)event.getEntity().getDirection()), event.getPos().relative(event.getFace()), stack).sendToPlayer((ServerPlayer)player);
                }
                event.setCanceled(true);
            }
            return;
        }
    }

    private static boolean playerRightClickInteract(@NotNull Player player, Level world, BlockPos pos) {
        return !player.isShiftKeyDown() || player.getMainHandItem() == null || player.getMainHandItem().getItem() == null || player.getMainHandItem().getItem().doesSneakBypassUse(player.getMainHandItem(), (LevelReader)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent.RightClickBlock event, @NotNull Player player) {
        Block heldBlock = Block.byItem((Item)event.getItemStack().getItem());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockScarecrow) {
            if (event.getLevel().isClientSide()) {
                event.setCanceled(true);
            } else {
                event.setCanceled(!EventHandler.onBlockHutPlaced(event.getLevel(), player, heldBlock, event.getPos().relative(event.getFace())));
            }
        }
    }

    public static boolean onBlockHutPlaced(@NotNull Level world, @NotNull Player player, Block block, BlockPos pos) {
        if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(world)) {
            MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(player);
            return false;
        }
        return EventHandler.onBlockHutPlaced(world, player, pos, block);
    }

    private static boolean onBlockHutPlaced(Level world, @NotNull Player player, BlockPos pos, Block block) {
        IColony colony = IColonyManager.getInstance().getIColony(world, pos);
        if (colony == null) {
            if (block instanceof BlockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(world, player) == null) {
                MessageUtils.format("tile.blockhut.messagenotownhall", new Object[0]).sendTo(player);
            } else {
                MessageUtils.format("tile.blockhut.messagetoofarfromtownhall", new Object[0]).sendTo(player);
            }
            return player.isCreative();
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            MessageUtils.format("tile.blockhut.messagenopermission", colony.getName()).sendTo(player);
            return false;
        }
        return player.isCreative() || colony.getBuildingManager().canPlaceAt(block, pos, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(@NotNull LevelEvent.Load event) {
        if (event.getLevel() instanceof Level) {
            IColonyManager.getInstance().onWorldLoad((Level)event.getLevel());
        }
        if (event.getLevel().isClientSide() && ((Boolean)((ClientConfiguration)MineColonies.getConfig().getClient()).holidayFeatures.get()).booleanValue() && (LocalDateTime.now().getDayOfMonth() == 31 && LocalDateTime.now().getMonth() == Month.OCTOBER || LocalDateTime.now().getDayOfMonth() == 1 && LocalDateTime.now().getMonth() == Month.NOVEMBER || LocalDateTime.now().getDayOfMonth() == 2 && LocalDateTime.now().getMonth() == Month.NOVEMBER)) {
            RenderBipedCitizen.isItGhostTime = false;
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(@NotNull LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide() && event.getLevel() instanceof Level) {
            IColonyManager.getInstance().onWorldUnload((Level)event.getLevel());
        }
        if (event.getLevel().isClientSide()) {
            IColonyManager.getInstance().resetColonyViews();
            Log.getLogger().info("Removed all colony views");
        }
    }

    @SubscribeEvent
    public static void onCropTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (!event.getLevel().isClientSide() && event.getEntity() instanceof AbstractEntityCitizen && ((AbstractEntityCitizen)event.getEntity()).getCitizenJobHandler().getColonyJob() instanceof JobFarmer && ((AbstractEntityCitizen)event.getEntity()).getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SOFT_SHOES) > 0.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityConverted(@NotNull LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ZombieVillager && event.getOutcome() == EntityType.VILLAGER) {
            Level world = entity.getCommandSenderWorld();
            IColony colony = IColonyManager.getInstance().getIColony(world, entity.blockPosition());
            if (colony != null && colony.hasBuilding("tavern", 1, false)) {
                event.setCanceled(true);
                if (EventHooks.canLivingConvert((LivingEntity)entity, ModEntities.VISITOR, null)) {
                    IVisitorData visitorData = (IVisitorData)colony.getVisitorManager().createAndRegisterCivilianData();
                    BlockPos tavernPos = colony.getBuildingManager().getRandomBuilding(b -> !b.getModulesByType(TavernBuildingModule.class).isEmpty());
                    IBuilding tavern = colony.getBuildingManager().getBuilding(tavernPos);
                    visitorData.setHomeBuilding(tavern);
                    visitorData.setBedPos(tavernPos);
                    tavern.getModulesByType(TavernBuildingModule.class).forEach(mod -> mod.getExternalCitizens().add(visitorData.getId()));
                    int recruitLevel = world.random.nextInt(10 * tavern.getBuildingLevel()) + 15;
                    List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
                    visitorData.getCitizenSkillHandler().init(recruitLevel);
                    colony.getVisitorManager().spawnOrCreateCivilian(visitorData, world, entity.blockPosition(), false);
                    colony.getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(entity.blockPosition(), visitorData.getName()));
                    if (visitorData.getEntity().isPresent()) {
                        AbstractEntityCitizen visitorEntity = visitorData.getEntity().get();
                        for (EquipmentSlot slotType : EquipmentSlot.values()) {
                            ItemStack itemstack = entity.getItemBySlot(slotType);
                            if (slotType.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || itemstack.isEmpty()) continue;
                            visitorEntity.setItemSlot(slotType, itemstack);
                        }
                    }
                    if (!entity.isSilent()) {
                        world.levelEvent((Player)null, 1027, entity.blockPosition(), 0);
                    }
                    entity.remove(Entity.RemovalReason.DISCARDED);
                    Tuple<Item, Integer> cost = recruitCosts.get(world.random.nextInt(recruitCosts.size()));
                    visitorData.setRecruitCosts(new ItemStack((ItemLike)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
                    visitorData.triggerInteraction(new RecruitmentInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.recruitstorycured", (Object[])new Object[]{visitorData.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        double lastTickMs = (double)event.getServer().getTickTimesNanos()[event.getServer().getTickCount() % 100] * 1.0E-6;
        TickRateStateMachine.slownessFactor = lastTickMs > 50.0 ? Mth.clamp((double)(lastTickMs / 50.0), (double)1.0, (double)5.0) : 1.0;
    }
}

