/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobEscapeWater
extends AbstractPathJob
implements IDestinationPathJob {
    @NotNull
    protected final BlockPos avoid;
    private BlockPos preferredDirection;

    public PathJobEscapeWater(Level world, @NotNull BlockPos start, int range, Mob entity) {
        super(world, start, 500, new PathResult(), entity);
        IColony colony;
        this.avoid = start;
        this.preferredDirection = entity.blockPosition().offset((Vec3i)entity.blockPosition().subtract((Vec3i)this.avoid).multiply(range));
        if (entity instanceof AbstractEntityCitizen && (colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColonyOrRegister()) != null) {
            this.preferredDirection = colony.getCenter();
        }
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.getX(), this.start.getY(), this.start.getZ(), this.avoid.getX(), this.avoid.getY(), this.avoid.getZ()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.dist(this.preferredDirection, x, y, z) * 2.0 / ((double)y / 10.0);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return this.cachedBlockLookup.getBlockState(n.x, n.y, n.z).isAir() && this.cachedBlockLookup.getBlockState(n.x, n.y + 1, n.z).isAir() && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        this.getPathingOptions().setWalkUnderWater(true);
        this.getPathingOptions().swimCost = 1.0;
        this.getPathingOptions().swimCostEnter = 1.0;
        this.getPathingOptions().nonLadderClimbableCost = 1.0;
    }

    @Override
    public BlockPos getDestination() {
        return this.preferredDirection;
    }
}

