/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenMournHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class CitizenMournHandler
implements ICitizenMournHandler {
    private Set<String> deceasedCitizens = new HashSet<String>();
    private boolean isMourning;

    public CitizenMournHandler(ICitizenData data) {
    }

    @Override
    public void read(CompoundTag compound) {
        this.isMourning = compound.getBoolean("mourning");
        ListTag tag = compound.getList("deceased", 8);
        for (int i = 0; i < tag.size(); ++i) {
            this.deceasedCitizens.add(tag.getString(i));
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.putBoolean("mourning", this.isMourning);
        ListTag deceasedNbt = new ListTag();
        for (String deceased : this.deceasedCitizens) {
            deceasedNbt.add((Object)StringTag.valueOf((String)deceased));
        }
        compound.put("deceased", (Tag)deceasedNbt);
    }

    @Override
    public void addDeceasedCitizen(String name) {
        this.deceasedCitizens.add(name);
    }

    @Override
    public Set<String> getDeceasedCitizens() {
        return this.deceasedCitizens;
    }

    @Override
    public void removeDeceasedCitizen(String name) {
        this.deceasedCitizens.remove(name);
    }

    @Override
    public void clearDeceasedCitizen() {
        this.deceasedCitizens.clear();
    }

    @Override
    public boolean shouldMourn() {
        return !this.deceasedCitizens.isEmpty();
    }

    @Override
    public boolean isMourning() {
        return this.isMourning;
    }

    @Override
    public void setMourning(boolean mourn) {
        this.isMourning = mourn;
    }
}

