/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructure;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingStructureHandler<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractStructureHandler {
    private static final double XP_EACH_BLOCK = 0.05;
    private final AbstractEntityAIStructure<J, B> structureAI;
    private final Stage[] stages;
    private IBuilding building;
    private int stage;

    public BuildingStructureHandler(Level world, BlockPos worldPos, Future<Blueprint> blueprintFuture, RotationMirror rotMir, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, blueprintFuture, rotMir);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    public BuildingStructureHandler(Level world, BlockPos worldPos, Blueprint blueprint, RotationMirror rotMir, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, blueprint, rotMir);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    @Nullable
    public Stage getStage() {
        if (this.stage >= this.stages.length) {
            return null;
        }
        return this.stages[this.stage];
    }

    public boolean nextStage() {
        return ++this.stage < this.stages.length;
    }

    public void setStage(Stage stage) {
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] != stage) continue;
            this.stage = i;
            return;
        }
    }

    public void prePlacementLogic(BlockPos worldPos, BlockState blockState, List<ItemStack> requiredItems) {
        WorkerUtil.faceBlock(worldPos, this.structureAI.getWorker());
        this.structureAI.getWorker().setItemSlot(EquipmentSlot.MAINHAND, requiredItems.isEmpty() ? ItemStackUtils.EMPTY : requiredItems.get(0));
        if (Mth.floor((double)this.structureAI.getWorker().getX()) == worldPos.getX() && Mth.abs((int)(worldPos.getY() - (int)this.structureAI.getWorker().getY())) <= 1 && Mth.floor((double)this.structureAI.getWorker().getZ()) == worldPos.getZ() && this.structureAI.getWorker().getNavigation().isDone()) {
            EntityNavigationUtils.walkAwayFrom(this.structureAI.getWorker(), worldPos, 1, 1.0);
        }
        this.structureAI.getWorker().swing(InteractionHand.MAIN_HAND);
    }

    @Nullable
    public IItemHandler getInventory() {
        return this.structureAI.getWorker().getInventoryCitizen();
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        BlockState state = this.getBluePrint().getBlockState(pos);
        if (this.building != null) {
            this.building.registerBlockPosition(state, worldPos, this.getWorld());
        }
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
                this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("blocks_placed", this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().getDay());
            }
            this.structureAI.getWorker().queueSound(state.getSoundType().getPlaceSound(), worldPos, 10, 0);
        }
        if (state.getBlock() == ModBlocks.blockWayPoint) {
            this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().addWayPoint(worldPos, state);
        }
    }

    public void triggerEntitySuccess(BlockPos blockPos, List<ItemStack> list, boolean placement) {
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
            }
        }
    }

    public boolean hasRequiredItems(@NotNull List<ItemStack> requiredItems) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : requiredItems) {
            if (((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get()).checkIsEquipment(stack) && this.structureAI.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get())) {
                return false;
            }
            itemList.add(stack);
        }
        return AbstractEntityAIStructure.hasListOfResInInvOrRequest(this.structureAI, itemList, itemList.size() > 1) == AbstractEntityAIStructure.ItemCheckResult.SUCCESS;
    }

    public void consume(List<ItemStack> requiredItems) {
        if (this.getInventory() != null) {
            for (ItemStack tempStack : requiredItems) {
                if (ItemStackUtils.isEmpty(tempStack)) continue;
                InventoryUtils.reduceStackInItemHandler(this.getInventory(), tempStack);
            }
        }
    }

    public boolean isCreative() {
        return Constants.BUILDER_INF_RESOURECES;
    }

    public int getStepsPerCall() {
        return 1;
    }

    public int getMaxBlocksCheckedPerCall() {
        return 10000;
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.isEmpty() || itemStack.is(ItemTags.LEAVES) || itemStack.getItem() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).getItem();
    }

    public boolean allowReplace() {
        return this.getStage() != null && this.getStage() != Stage.CLEAR;
    }

    public ItemStack getHeldItem() {
        return this.structureAI.getWorker().getMainHandItem();
    }

    public BlockState getSolidBlockForPos(BlockPos worldPos, Function<BlockPos, @Nullable BlockState> virtualBlocks) {
        return this.structureAI.getSolidSubstitution(worldPos, virtualBlocks);
    }

    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !BlockUtils.isGoodFloorBlock((BlockState)blockState) || this.structureAI.shallReplaceSolidSubstitutionBlock(blockState.getBlock(), blockState);
    }

    public boolean fancyPlacement() {
        return true;
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.getBlock();
        Block block2 = state2.getBlock();
        if (block1 == Blocks.FLOWER_POT || block2 == Blocks.FLOWER_POT) {
            return block1 == block2;
        }
        return block1 == Blocks.GRASS_BLOCK && block2 == Blocks.DIRT || block2 == Blocks.GRASS_BLOCK && block1 == Blocks.DIRT || block1 == ModBlocks.blockRack && block2 == ModBlocks.blockRack;
    }

    public static enum Stage {
        CLEAR,
        BUILD_SOLID,
        CLEAR_WATER,
        CLEAR_NON_SOLIDS,
        DECORATE,
        SPAWN,
        REMOVE,
        REMOVE_WATER,
        WEAK_SOLID;

    }
}

