/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingChickenHerder;
import com.minecolonies.core.colony.jobs.JobChickenHerder;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkChickenHerder
extends AbstractEntityAIHerder<JobChickenHerder, BuildingChickenHerder> {
    private static final VisibleCitizenStatus FIND_CHICKEN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/chickenherder.png"), "com.minecolonies.gui.visiblestatus.chickenherder");

    public EntityAIWorkChickenHerder(@NotNull JobChickenHerder job) {
        super(job);
    }

    @Override
    public Class<BuildingChickenHerder> getExpectedBuildingClass() {
        return BuildingChickenHerder.class;
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.butcherAnimals();
    }

    @Override
    protected void butcherAnimal(@Nullable Animal animal) {
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.getMainHandItem())) {
            this.worker.swing(InteractionHand.MAIN_HAND);
            if (this.worker.getRandom().nextInt(1 + (100 - this.getSecondarySkillLevel()) / 5) <= 1) {
                animal.hurt(this.world.damageSources().source(DamageSourceKeys.DEFAULT, (Entity)this.worker), (float)this.getButcheringAttackDamage());
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            }
        }
    }
}

