/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFisherman;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import com.minecolonies.core.entity.other.NewBobberEntity;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobFindWater;
import com.minecolonies.core.entity.pathfinding.pathresults.WaterPathResult;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFisherman
extends AbstractEntityAISkill<JobFisherman, BuildingFisherman> {
    public static final String RENDER_META_FISH = "fish";
    public static final String RENDER_META_ROD = "rod";
    private static final int MAX_PONDS = 20;
    private static final int FISHING_SKILL_CHANCE = 10;
    private static final int CHANCE = 2;
    private static final int MIN_DISTANCE_TO_WATER = 3;
    private static final int MAX_FISHES_IN_INV = 10;
    private static final int MAX_ROTATIONS = 6;
    private static final int SEARCH_RANGE = 50;
    private static final double CHANCE_NEW_POND = 0.05;
    private static final int FISHING_TIMEOUT = 5;
    private static final int LURE_SPEED_DIVIDER = 25;
    private int executedRotations = 0;
    @Nullable
    private WaterPathResult pathResult;
    @Nullable
    private WaterPathResult lastPathResult;
    @Nullable
    private NewBobberEntity entityFishHook;
    private int stuckCounter = 3;

    public EntityAIWorkFisherman(@NotNull JobFisherman job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForFishing, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_CHECK_WATER, this::tryDifferentAngles, 1), new AITarget<Object>(AIWorkerState.FISHERMAN_SEARCHING_WATER, this::findWater, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_WALKING_TO_WATER, this::getToWater, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_START_FISHING, this::doFishing, 20));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public Class<BuildingFisherman> getExpectedBuildingClass() {
        return BuildingFisherman.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForFishing() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get())) {
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            this.playNeedRodSound();
            return this.getState();
        }
        return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
    }

    private void playNeedRodSound() {
        SoundUtils.playSoundAtCitizenWith((Level)this.world, this.worker.blockPosition(), EventType.MISSING_EQUIPMENT, this.worker.getCitizenData());
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    protected void updateRenderMetaData() {
        if (this.hasFish() && this.hasRodButNotEquipped()) {
            this.worker.setRenderMetadata("rodfish");
        } else if (this.hasRodButNotEquipped() && !this.hasFish()) {
            this.worker.setRenderMetadata(RENDER_META_ROD);
        } else {
            this.worker.setRenderMetadata(this.hasFish() ? RENDER_META_FISH : "");
        }
    }

    private boolean hasFish() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), item -> item.is(ItemTags.FISHES));
    }

    private boolean hasRodButNotEquipped() {
        return InventoryUtils.hasItemHandlerEquipmentWithLevel((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get(), 0, ((BuildingFisherman)this.building).getMaxEquipmentLevel()) && this.worker.getMainHandItem() != null && !((EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get()).checkIsEquipment(this.worker.getMainHandItem());
    }

    private IAIState getToWater() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (!this.walkToWater()) {
            return this.getState();
        }
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private boolean walkToWater() {
        return ((JobFisherman)this.job).getWater() != null && this.walkToSafePos(((JobFisherman)this.job).getWater().getB());
    }

    @NotNull
    private IAIState tryDifferentAngles() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.executedRotations >= 6) {
            ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
            ((JobFisherman)this.job).setWater(null);
            this.executedRotations = 0;
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.world.getBlockState(this.worker.blockPosition()).liquid()) {
            if (!BlockUtils.isAnySolid((BlockState)this.world.getBlockState(((JobFisherman)this.job).getWater().getB().below()))) {
                ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
                ((JobFisherman)this.job).setWater(null);
                this.executedRotations = 0;
                return AIWorkerState.START_WORKING;
            }
            ++this.executedRotations;
        }
        WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
        ++this.executedRotations;
        return AIWorkerState.FISHERMAN_START_FISHING;
    }

    private IAIState findWater() {
        this.executedRotations = 0;
        if (((JobFisherman)this.job).getPonds().size() >= 20 || this.lastPathResult != null && this.lastPathResult.pond == null && ((JobFisherman)this.job).getPonds().size() > 0) {
            return this.setRandomWater();
        }
        return this.findNewWater();
    }

    public WaterPathResult searchWater(int range, double speed, List<Tuple<BlockPos, BlockPos>> ponds) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.worker);
        PathJobFindWater job = new PathJobFindWater(CompatibilityUtils.getWorldFromEntity((Entity)this.worker), start, this.worker.getCitizenColonyHandler().getWorkBuilding().getPosition(), range, ponds, (Mob)this.worker);
        job.setPathingOptions(this.worker.getNavigation().getPathingOptions());
        WaterPathResult waterPathresult = job.getResult();
        waterPathresult.startJob(Pathfinding.getExecutor());
        return waterPathresult;
    }

    private IAIState setRandomWater() {
        if (((JobFisherman)this.job).getPonds().isEmpty()) {
            if ((this.pathResult != null && this.pathResult.failedToReachDestination() && this.lastPathResult == null || this.lastPathResult != null && this.lastPathResult.isEmpty && !this.lastPathResult.isCancelled()) && this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.fisherman.messagewatertoofar", (Object[])new Object[0]), ChatPriority.IMPORTANT));
            }
            if (this.pathResult == null || !this.pathResult.isInProgress()) {
                this.pathResult = this.searchWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            }
            return AIWorkerState.START_WORKING;
        }
        ((JobFisherman)this.job).setWater(((JobFisherman)this.job).getPonds().get(this.worker.getRandom().nextInt(((JobFisherman)this.job).getPonds().size())));
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private IAIState findNewWater() {
        if (this.pathResult == null) {
            this.pathResult = this.searchWater(150, 1.0, ((JobFisherman)this.job).getPonds());
            return this.getState();
        }
        if (this.pathResult.failedToReachDestination()) {
            return this.setRandomWater();
        }
        if (this.pathResult.isPathReachingDestination()) {
            if (this.pathResult.pond != null) {
                ((JobFisherman)this.job).setWater(new Tuple<BlockPos, BlockPos>(this.pathResult.pond, this.pathResult.parent));
                ((JobFisherman)this.job).addToPonds(this.pathResult.pond, this.pathResult.parent);
            }
            this.lastPathResult = this.pathResult;
            this.pathResult = null;
            return AIWorkerState.FISHERMAN_CHECK_WATER;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIWorkerState.PREPARING;
        }
        return this.getState();
    }

    @Nullable
    private IAIState doFishing() {
        @Nullable IAIState notReadyState = this.isReadyToFish();
        if (notReadyState != null) {
            return notReadyState;
        }
        if (this.caughtFish()) {
            this.playCaughtFishSound();
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("fish_caught", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
            ((BuildingFisherman)this.building).getModule(BuildingModules.STATS_MODULE).increment("fish_caught");
            if (this.worker.getRandom().nextDouble() < 0.05) {
                ((JobFisherman)this.job).setWater(null);
                return AIWorkerState.FISHERMAN_SEARCHING_WATER;
            }
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        return this.throwOrRetrieveHook();
    }

    private void playCaughtFishSound() {
        SoundUtils.playSoundAtCitizenWith((Level)this.world, this.worker.blockPosition(), EventType.SUCCESS, this.worker.getCitizenData());
    }

    private IAIState throwOrRetrieveHook() {
        if (this.entityFishHook == null) {
            if (this.testRandomChance()) {
                return this.getState();
            }
            this.throwRod();
        } else {
            if (this.isFishHookStuck()) {
                if (this.stuckCounter > 3) {
                    this.stuckCounter = 0;
                    this.retrieveRod();
                    return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
                }
                ++this.stuckCounter;
            } else {
                this.stuckCounter = 0;
            }
            this.entityFishHook.setInUse();
        }
        return this.getState();
    }

    private void throwRod() {
        if (!this.world.isClientSide) {
            WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
            this.world.playSound(null, this.worker.blockPosition(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, (float)(0.4 / ((double)this.world.random.nextFloat() * 0.4 + 0.8)));
            this.entityFishHook = new NewBobberEntity(ModEntities.FISHHOOK, this.worker, this.worker.level(), EnchantmentHelper.getFishingLuckBonus((ServerLevel)((ServerLevel)this.worker.level()), (ItemStack)this.worker.getMainHandItem(), (Entity)this.worker), (int)((float)(5 + this.getPrimarySkillLevel() / 25) + EnchantmentHelper.getFishingTimeReduction((ServerLevel)((ServerLevel)this.worker.level()), (ItemStack)this.worker.getMainHandItem(), (Entity)this.worker)));
            this.world.addFreshEntity((Entity)this.entityFishHook);
        }
        this.worker.swing(this.worker.getUsedItemHand());
    }

    private boolean isFishHookStuck() {
        return !this.entityFishHook.isInWater() && (this.entityFishHook.onGround() || this.entityFishHook.shouldStopFishing(this.worker)) || !this.entityFishHook.isAlive() || this.entityFishHook.getHookedEntity() != null;
    }

    private boolean testRandomChance() {
        this.setDelay(5);
        double chance = this.worker.getRandom().nextInt(10 + this.getSecondarySkillLevel() / 5);
        return chance <= 2.0;
    }

    private IAIState isReadyToFish() {
        int rodSlot = this.getRodSlot();
        if (rodSlot == -1) {
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.PREPARING;
        }
        if (!Utils.isBlockInRange((Level)this.world, Blocks.WATER, (int)this.worker.getX(), (int)this.worker.getY(), (int)this.worker.getZ(), 3)) {
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        if (this.worker.getMainHandItem() == null || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.getMainHandItem(), this.worker.getItemHandlerCitizen().getStackInSlot(rodSlot), false, true)) {
            this.equipRod();
            return this.getState();
        }
        return null;
    }

    private void equipRod() {
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, this.getRodSlot());
    }

    private int getRodSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get(), 0, ((BuildingFisherman)this.building).getMaxEquipmentLevel());
    }

    private boolean caughtFish() {
        if (this.entityFishHook == null) {
            return false;
        }
        if (!this.entityFishHook.isReadyToCatch()) {
            return false;
        }
        if (this.testRandomChance()) {
            return false;
        }
        this.worker.setCanPickUpLoot(true);
        this.retrieveRod();
        return true;
    }

    private void retrieveRod() {
        if (this.entityFishHook != null) {
            this.worker.swing(this.worker.getUsedItemHand());
            int i = this.entityFishHook.retrieve(this.worker.getMainHandItem());
            this.generateBonusLoot();
            CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, i);
            this.entityFishHook = null;
        }
    }

    private void generateBonusLoot() {
        LootParams context = new LootParams.Builder(this.world).withParameter(LootContextParams.ORIGIN, (Object)this.entityFishHook.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.entityFishHook).withParameter(LootContextParams.TOOL, (Object)this.worker.getMainHandItem()).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.worker).withLuck((float)this.getPrimarySkillLevel()).create(LootContextParamSets.FISHING);
        LootTable bonusLoot = this.world.getServer().reloadableRegistries().getLootTable(ModLootTables.FISHERMAN_BONUS.get(((BuildingFisherman)this.building).getBuildingLevel()));
        ObjectArrayList loot = bonusLoot.getRandomItems(context);
        for (ItemStack itemstack : loot) {
            ItemEntity itementity = new ItemEntity((Level)this.world, this.entityFishHook.position().x, this.entityFishHook.position().y, this.entityFishHook.position().z, itemstack);
            double d0 = this.worker.getX() - this.entityFishHook.position().x;
            double d1 = this.worker.getY() + 0.5 - this.entityFishHook.position().y;
            double d2 = this.worker.getZ() - this.entityFishHook.position().z;
            itementity.noPhysics = true;
            itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
            this.world.addFreshEntity((Entity)itementity);
            this.worker.level().addFreshEntity((Entity)new ExperienceOrb(this.worker.level(), this.worker.getX(), this.worker.getY() + 0.5, this.worker.getZ() + 0.5, 2));
        }
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

