/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingComposter;
import com.minecolonies.core.colony.jobs.JobComposter;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.tileentities.TileEntityBarrel;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkComposter
extends AbstractEntityAIInteract<JobComposter, BuildingComposter> {
    private static final double BASE_XP_GAIN = 1.0;
    private BlockPos currentTarget;
    private static final int TICKS_UNTIL_COMPLAIN = 12000;
    private int ticksToComplain = 0;
    private static final int DECIDE_DELAY = 40;
    private static final int AFTER_TASK_DELAY = 5;
    public static final String COMPOSTABLE_LIST = "compostables";
    private static final VisibleCitizenStatus COMPOST = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/composter.png"), "com.minecolonies.gui.visiblestatus.composter");

    public EntityAIWorkComposter(@NotNull JobComposter job) {
        super(job);
        super.registerTargets(new AIEventTarget<Object>(AIBlockingEventType.AI_BLOCKING, this::accelerateBarrels, 20), new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.GET_MATERIALS, this::getMaterials, 20), new AITarget<Object>(AIWorkerState.START_WORKING, this::decideWhatToDo, 1), new AITarget<Object>(AIWorkerState.COMPOSTER_FILL, this::fillBarrels, 10), new AITarget<Object>(AIWorkerState.COMPOSTER_HARVEST, this::harvestBarrels, 10));
        this.worker.setCanPickUpLoot(true);
    }

    private IAIState accelerateBarrels() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 * 2;
        Level world = ((BuildingComposter)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingComposter)this.building).getBarrels()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.getBlockEntity(pos)) instanceof TileEntityBarrel)) continue;
            TileEntityBarrel barrel = (TileEntityBarrel)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!barrel.checkIfWorking() || barrel.isDone()) continue;
                barrel.tick();
            }
        }
        return null;
    }

    private IAIState getMaterials() {
        int slot;
        if (!this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        ImmutableList<ItemStorage> list = ((ItemListModule)((BuildingComposter)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(COMPOSTABLE_LIST))).getList();
        if (list.isEmpty()) {
            this.complain();
            return this.getState();
        }
        if (InventoryUtils.hasItemInProvider((IItemHandlerCapProvider)this.building, stack -> list.contains(new ItemStorage((ItemStack)stack)))) {
            InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(this.building, InventoryUtils.findFirstSlotInProviderNotEmptyWith((IItemHandlerCapProvider)this.building, stack -> list.contains(new ItemStorage((ItemStack)stack))), (IItemHandler)this.worker.getInventoryCitizen());
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> list.contains(new ItemStorage((ItemStack)stack)))) >= 0) {
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            return AIWorkerState.START_WORKING;
        }
        this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        if (!((BuildingComposter)this.building).hasWorkerOpenRequests(this.worker.getCitizenData().getId())) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            for (ItemStorage item : list) {
                ItemStack itemStack = item.getItemStack();
                itemStack.setCount(itemStack.getMaxStackSize());
                itemList.add(itemStack);
            }
            if (!itemList.isEmpty()) {
                this.worker.getCitizenData().createRequestAsync(new StackList(itemList, "com.minecolonies.coremod.request.compostable", 64 * ((BuildingComposter)this.building).getBarrels().size(), 1, ((BuildingComposter)this.building).getSetting(BuildingComposter.MIN).getValue()));
            }
        }
        this.setDelay(2);
        return AIWorkerState.START_WORKING;
    }

    private IAIState decideWhatToDo() {
        BlockEntity te;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (!this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        BuildingComposter building = (BuildingComposter)this.building;
        for (BlockPos barrel : building.getBarrels()) {
            te = this.world.getBlockEntity(barrel);
            if (!(te instanceof TileEntityBarrel)) continue;
            this.currentTarget = barrel;
            if (!((TileEntityBarrel)te).isDone()) continue;
            this.setDelay(40);
            this.worker.getCitizenData().setVisibleStatus(COMPOST);
            return AIWorkerState.COMPOSTER_HARVEST;
        }
        for (BlockPos barrel : building.getBarrels()) {
            te = this.world.getBlockEntity(barrel);
            if (!(te instanceof TileEntityBarrel) || ((TileEntityBarrel)te).checkIfWorking()) continue;
            this.currentTarget = barrel;
            this.setDelay(40);
            this.worker.getCitizenData().setVisibleStatus(COMPOST);
            return AIWorkerState.COMPOSTER_FILL;
        }
        this.setDelay(40);
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillBarrels() {
        if (this.worker.getItemInHand(InteractionHand.MAIN_HAND) == ItemStack.EMPTY) {
            int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> ((ItemListModule)((BuildingComposter)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(COMPOSTABLE_LIST))).isItemInList(new ItemStorage((ItemStack)stack)));
            if (slot >= 0) {
                this.worker.setItemInHand(InteractionHand.MAIN_HAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            } else {
                return AIWorkerState.GET_MATERIALS;
            }
        }
        if (!this.walkToWorkPos(this.currentTarget)) {
            this.setDelay(2);
            return this.getState();
        }
        if (this.world.getBlockEntity(this.currentTarget) instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)this.world.getBlockEntity(this.currentTarget);
            CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.currentTarget);
            barrel.addItem(this.worker.getItemInHand(InteractionHand.MAIN_HAND));
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            this.incrementActionsDone();
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvestBarrels() {
        if (!this.walkToWorkPos(this.currentTarget)) {
            this.setDelay(2);
            return this.getState();
        }
        if (this.world.getBlockEntity(this.currentTarget) instanceof TileEntityBarrel) {
            CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.currentTarget);
            TileEntityBarrel te = (TileEntityBarrel)this.world.getBlockEntity(this.currentTarget);
            ItemStack compost = te.retrieveCompost(this.getLootMultiplier(this.worker.getRandom()));
            if (((BuildingComposter)this.building).getSetting(BuildingComposter.PRODUCE_DIRT).getValue().booleanValue()) {
                if ((double)(this.worker.getRandom().nextInt(100) + 1) <= 5.0 * (1.0 + this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PODZOL_CHANCE))) {
                    InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Blocks.PODZOL, 1));
                } else {
                    InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Blocks.DIRT, 1));
                }
            } else {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), compost);
            }
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private double getLootMultiplier(RandomSource random) {
        int citizenLevel = (int)((double)this.getSecondarySkillLevel() / 2.0);
        int diceResult = random.nextInt(100);
        if (diceResult <= citizenLevel * 2) {
            return 2.0;
        }
        if (diceResult <= citizenLevel * 4) {
            return 1.5;
        }
        if (diceResult <= citizenLevel * 8) {
            return 1.25;
        }
        return 1.0;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private void complain() {
        if (this.ticksToComplain <= 0) {
            this.ticksToComplain = 12000;
            MessageUtils.format("entity.composter.noitems", new Object[0]).sendTo(((BuildingComposter)this.building).getColony()).forAllPlayers();
        } else {
            --this.ticksToComplain;
        }
    }

    @Override
    public Class<BuildingComposter> getExpectedBuildingClass() {
        return BuildingComposter.class;
    }
}

