/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.core.colony.jobs.JobLumberjack;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.ai.workers.util.Tree;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToWithPassable;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.TreePathResult;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkLumberjack
extends AbstractEntityAICrafting<JobLumberjack, BuildingLumberjack> {
    public static final String RENDER_META_LOGS = "logs";
    public static final int SEARCH_RANGE = 50;
    private static final int SEARCH_INCREMENT = 5;
    private static final int SEARCH_LIMIT = 150;
    public static final String SAPLINGS_LIST = "saplings";
    public static final float RANGE_VERTICAL_PICKUP = 2.0f;
    public static final float RANGE_HORIZONTAL_PICKUP = 5.0f;
    private static final int MIN_WORKING_RANGE = 2;
    private static final int WAIT_BEFORE_SAPLING = 50;
    private static final int MAX_WAITING_TIME = 50;
    private static final int TIMEOUT_DELAY = 10;
    private static final int WAIT_BEFORE_SEARCH = 400;
    private static final int WAIT_BEFORE_INCREMENT = 20;
    private static final int MAX_BLOCKS_MINED = 32;
    private static final int GATHERING_DELAY = 3;
    private static final VisibleCitizenStatus SEARCH = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/lumberjack_search.png"), "com.minecolonies.gui.visiblestatus.lumberjack_search");
    private static final double XP_PER_TREE = 1.0;
    private BlockPos workFrom;
    private int timeWaited = 0;
    private boolean checkedInHut = false;
    @Nullable
    private TreePathResult pathResult;
    private int searchIncrement = 0;
    private PathResult<?> pathToTree;

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return this.getActionsDoneUntilDumping();
    }

    public EntityAIWorkLumberjack(@NotNull JobLumberjack job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.LUMBERJACK_START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForWoodcutting, 20), new AITarget<Object>(AIWorkerState.LUMBERJACK_SEARCHING_TREE, this::findTrees, 20), new AITarget<Object>(AIWorkerState.LUMBERJACK_CHOP_TREE, this::chopWood, 20), new AITarget<Object>(AIWorkerState.LUMBERJACK_GATHERING, this::gathering, 20), new AITarget<Object>(AIWorkerState.LUMBERJACK_NO_TREES_FOUND, this::waitBeforeCheckingAgain, 20), new AITarget<Object>(AIWorkerState.LUMBERJACK_GATHERING_2, this::gathering2, 20));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public Class<BuildingLumberjack> getExpectedBuildingClass() {
        return BuildingLumberjack.class;
    }

    @Override
    protected IAIState decide() {
        if (this.checkIfStuck()) {
            this.tryUnstuck();
            return this.getState();
        }
        if (!this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobLumberjack)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        if (((JobLumberjack)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        if (((JobLumberjack)this.job).getCurrentTask() == null) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        return this.getNextCraftingState();
    }

    private boolean isStackLog(@Nullable ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack) && stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock().defaultBlockState().is(BlockTags.LOGS);
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForWoodcutting() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.axe.get()) || this.checkForToolOrWeapon(((BuildingLumberjack)this.building).getSetting(AbstractBuilding.USE_SHEARS).getValue() != false ? (EquipmentTypeEntry)ModEquipmentTypes.shears.get() : (EquipmentTypeEntry)ModEquipmentTypes.hoe.get())) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    private IAIState waitBeforeCheckingAgain() {
        this.pathResult = null;
        if (this.hasNotDelayed(400)) {
            return this.getState();
        }
        this.resetGatheringItems();
        return AIWorkerState.LUMBERJACK_GATHERING_2;
    }

    private IAIState gathering2() {
        if (((BuildingLumberjack)this.building).shouldRestrict()) {
            if (this.getItemsForPickUp() == null) {
                this.searchForItems(AABB.encapsulatingFullBlocks((BlockPos)((BuildingLumberjack)this.building).getStartRestriction(), (BlockPos)((BuildingLumberjack)this.building).getEndRestriction()).inflate(5.0, 2.0, 5.0));
            }
            if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
                this.gatherItems();
                return this.getState();
            }
        }
        this.resetGatheringItems();
        if (ColonyConstants.rand.nextInt(100) <= 10) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    @Override
    protected boolean isItemWorthPickingUp(ItemStack stack) {
        if (this.getState() == AIWorkerState.LUMBERJACK_GATHERING_2) {
            return stack.is(ItemTags.SAPLINGS) || stack.is(Tags.Items.MUSHROOMS) || stack.is(ModTags.fungi);
        }
        return super.isItemWorthPickingUp(stack);
    }

    private IAIState findTrees() {
        if (((JobLumberjack)this.job).getTree() == null) {
            return this.findTree();
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.LUMBERJACK_CHOP_TREE;
    }

    private IAIState findTree() {
        this.worker.getCitizenData().setVisibleStatus(SEARCH);
        if (this.pathResult != null && this.pathResult.isComputing()) {
            return this.getState();
        }
        if (this.pathResult == null) {
            if (((BuildingLumberjack)this.building).shouldRestrict()) {
                BlockPos startPos = ((BuildingLumberjack)this.building).getStartRestriction();
                BlockPos endPos = ((BuildingLumberjack)this.building).getEndRestriction();
                this.pathResult = this.worker.getNavigation().walkToTree(startPos, endPos, 1.0, (List<ItemStorage>)((ItemListModule)((BuildingLumberjack)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST))).getList(), ((BuildingLumberjack)this.building).getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColonyOrRegister());
            } else {
                this.pathResult = this.worker.getNavigation().walkToTree(50 + this.searchIncrement, 1.0, (List<ItemStorage>)((ItemListModule)((BuildingLumberjack)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST))).getList(), ((BuildingLumberjack)this.building).getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColonyOrRegister());
            }
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.setNewTree((BuildingLumberjack)this.building);
        }
        return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState setNewTree(BuildingLumberjack building) {
        if (this.pathResult.treeLocation == null) {
            if (building.shouldRestrict() || this.searchIncrement + 50 > 150) return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
            this.searchIncrement += 5;
            this.setDelay(20);
        } else {
            ((JobLumberjack)this.job).setTree(new Tree((Level)this.world, this.pathResult.treeLocation, building.shouldRestrict() ? null : building.getColony()));
            if (((JobLumberjack)this.job).getTree().isTree()) {
                ((JobLumberjack)this.job).getTree().findLogs((Level)this.world, building.shouldRestrict() ? null : building.getColony());
                return AIWorkerState.LUMBERJACK_CHOP_TREE;
            }
            ((JobLumberjack)this.job).setTree(null);
        }
        this.pathResult = null;
        return this.getState();
    }

    private IAIState chopWood() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.axe.get())) {
            return AIWorkerState.IDLE;
        }
        if (((JobLumberjack)this.job).getTree() == null) {
            return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
        }
        return this.chopTree();
    }

    private IAIState chopTree() {
        BlockPos spawnPoint;
        boolean shouldBreakLeaves;
        boolean bl = shouldBreakLeaves = ((BuildingLumberjack)this.building).shouldDefoliate() || ((JobLumberjack)this.job).getTree().isNetherTree();
        if (((BuildingLumberjack)this.building).shouldRestrict() && !BlockPosUtil.isInArea(((BuildingLumberjack)this.building).getStartRestriction(), ((BuildingLumberjack)this.building).getEndRestriction(), ((JobLumberjack)this.job).getTree().getLocation())) {
            ((JobLumberjack)this.job).setTree(null);
            this.pathResult = null;
            return AIWorkerState.START_WORKING;
        }
        if ((((JobLumberjack)this.job).getTree().hasLogs() || shouldBreakLeaves && ((JobLumberjack)this.job).getTree().hasLeaves() || this.checkedInHut) && !this.walkToTree(((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty() ? ((JobLumberjack)this.job).getTree().getLocation() : ((JobLumberjack)this.job).getTree().getStumpLocations().get(0))) {
            if (this.checkIfStuck()) {
                this.tryUnstuck();
            }
            return this.getState();
        }
        if (!(((JobLumberjack)this.job).getTree().hasLogs() || shouldBreakLeaves && ((JobLumberjack)this.job).getTree().hasLeaves())) {
            if (this.hasNotDelayed(50)) {
                return this.getState();
            }
            if (((BuildingLumberjack)this.building).shouldReplant()) {
                this.plantSapling();
            } else {
                ((JobLumberjack)this.job).setTree(null);
                this.pathResult = null;
                this.checkedInHut = false;
            }
            ((BuildingLumberjack)this.building).getColony().getStatisticsManager().increment("trees_cut", ((BuildingLumberjack)this.building).getColony().getDay());
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
            this.workFrom = null;
            this.setDelay(60);
            return AIWorkerState.LUMBERJACK_GATHERING;
        }
        if (this.isOnSapling() && (spawnPoint = EntityUtils.getSpawnPoint((Level)this.world, this.workFrom)) != null) {
            WorkerUtil.setSpawnPoint(spawnPoint, this.worker);
        }
        if (((JobLumberjack)this.job).getTree().hasLeaves() && shouldBreakLeaves) {
            BlockPos leaf = ((JobLumberjack)this.job).getTree().peekNextLeaf();
            if (!this.mineBlock(leaf, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLeaf();
        } else if (((JobLumberjack)this.job).getTree().hasLogs()) {
            BlockPos log = ((JobLumberjack)this.job).getTree().peekNextLog();
            if (((JobLumberjack)this.job).getTree().isDynamicTree()) {
                if (!this.mineBlock(log, this.workFrom, false, false, Compatibility.getDynamicTreeBreakAction((Level)this.world, log, this.worker.getItemInHand(InteractionHand.MAIN_HAND), this.worker.blockPosition()))) {
                    return this.getState();
                }
                for (int i = 0; i < 6; ++i) {
                    this.incrementActionsDone();
                }
                this.setDelay(100);
            } else if (!this.mineBlock(log, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLog();
            this.worker.decreaseSaturationForContinuousAction();
        }
        return this.getState();
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingLumberjack)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.getItem().getDescriptionId(), stack.getCount());
        }
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (this.world.getRandom().nextInt(100) <= 95 || !stack.is(ItemTags.WART_BLOCKS)) continue;
            Block wartBlock = ((BlockItem)stack.getItem()).getBlock();
            ItemStack fungus = IColonyManager.getInstance().getCompatibilityManager().getSaplingForLeaf(wartBlock);
            if (fungus == null) continue;
            newDrops.add(fungus);
        }
        if (newDrops.isEmpty()) {
            return drops;
        }
        return newDrops;
    }

    public boolean walkToTree(BlockPos workAt) {
        if (this.workFrom == null || this.world.getBlockState(this.workFrom.above()).is(BlockTags.SAPLINGS) || this.world.getBlockState(this.workFrom).is(BlockTags.SAPLINGS)) {
            this.workFrom = this.getWorkingPosition(workAt);
        }
        if (MathUtils.twoDimDistance(this.worker.blockPosition(), this.workFrom) <= 2.0) {
            return true;
        }
        if (this.pathToTree == null || !this.pathToTree.isInProgress()) {
            this.pathToTree = ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobMoveToWithPassable((Level)this.world, PathfindingUtils.prepareStart((LivingEntity)this.worker), this.workFrom, 50, (Mob)this.worker, this::isPassable), this.workFrom, 1.0, true);
        }
        return false;
    }

    private Boolean isPassable(BlockState blockState) {
        return blockState.is(BlockTags.LEAVES) || blockState.is(ModTags.hugeMushroomBlocks);
    }

    private boolean checkIfStuck() {
        if (!this.worker.getNavigation().isDone()) {
            Path path = this.worker.getNavigation().getPath();
            if (path != null) {
                if (path.getNodeCount() > path.getNextNodeIndex()) {
                    return true;
                }
                return path.getNodeCount() == 0;
            }
            return true;
        }
        return false;
    }

    private void tryUnstuck() {
        Path path;
        if (!this.worker.getNavigation().isDone() && (path = this.worker.getNavigation().getPath()) != null) {
            int i;
            ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
            Node next = path.getNode(Math.min(path.getNextNodeIndex() + 1, path.getNodeCount() - 1));
            for (i = 0; i < 2; ++i) {
                checkPositions.add(new BlockPos(next.x, next.y + i, next.z));
            }
            if (next.cameFrom != null) {
                next = next.cameFrom;
                for (i = 0; i < 2; ++i) {
                    checkPositions.add(new BlockPos(next.x, next.y + i, next.z));
                }
                if (next.cameFrom != null) {
                    next = next.cameFrom;
                    for (i = 0; i < 2; ++i) {
                        checkPositions.add(new BlockPos(next.x, next.y + i, next.z));
                    }
                }
            }
            this.mineIfEqualsBlockTag(checkPositions, (TagKey<Block>)BlockTags.LEAVES);
            this.mineIfEqualsBlockTag(checkPositions, ModTags.hugeMushroomBlocks);
            return;
        }
        ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            checkPositions.add(new BlockPos(this.worker.blockPosition().getX(), this.worker.blockPosition().getY(), this.worker.blockPosition().getZ()).relative(direction));
            checkPositions.add(new BlockPos(this.worker.blockPosition().getX(), this.worker.blockPosition().getY() + 1, this.worker.blockPosition().getZ()).relative(direction));
        }
        this.mineIfEqualsBlockTag(checkPositions, (TagKey<Block>)BlockTags.LEAVES);
        this.mineIfEqualsBlockTag(checkPositions, ModTags.hugeMushroomBlocks);
    }

    private boolean mineIfEqualsBlockTag(List<BlockPos> blockPositions, TagKey<Block> tag) {
        for (BlockPos currentPos : blockPositions) {
            if ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).pathfindingDebugVerbosity.get() > 0) {
                Log.getLogger().info(String.format("Check Leaves Pos(%d, %d, %d) is %s: %s", currentPos.getX(), currentPos.getY(), currentPos.getZ(), tag.toString(), this.world.getBlockState(currentPos).is(tag)));
            }
            if (!this.world.getBlockState(currentPos).is(tag)) continue;
            this.mineBlock(currentPos);
            return true;
        }
        return false;
    }

    private void plantSapling() {
        if (this.plantSapling(((JobLumberjack)this.job).getTree().getLocation())) {
            ((JobLumberjack)this.job).setTree(null);
            this.pathResult = null;
            this.checkedInHut = false;
        }
    }

    private boolean isOnSapling() {
        return this.world.getBlockState(this.worker.blockPosition()).is(BlockTags.SAPLINGS) || this.world.getBlockState(this.worker.blockPosition().above()).is(BlockTags.SAPLINGS) || this.world.getBlockState(this.worker.blockPosition().below()).is(BlockTags.SAPLINGS);
    }

    private boolean plantSapling(@NotNull BlockPos location) {
        BlockState worldState = this.world.getBlockState(location);
        Block worldBlock = worldState.getBlock();
        if (!(worldBlock instanceof AirBlock) && !worldState.is(BlockTags.SAPLINGS) && worldBlock != Blocks.SNOW) {
            return true;
        }
        int saplingSlot = this.findSaplingSlot();
        if (saplingSlot != -1) {
            ItemStack stack = this.getInventory().getStackInSlot(saplingSlot);
            CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, saplingSlot);
            if (((JobLumberjack)this.job).getTree().isDynamicTree() && Compatibility.isDynamicTreeSapling(stack)) {
                Compatibility.plantDynamicSapling((Level)this.world, location, stack);
                this.getInventory().extractItem(saplingSlot, 1, false);
                this.worker.swing(this.worker.getUsedItemHand());
                this.timeWaited = 0;
                this.incrementActionsDoneAndDecSaturation();
                this.setDelay(10);
                return true;
            }
            Block block = ((BlockItem)stack.getItem()).getBlock();
            this.placeSaplings(saplingSlot, stack, block);
            SoundType soundType = block.getSoundType(this.world.getBlockState(location), (LevelReader)this.world, location, (Entity)this.worker);
            this.world.playSound(null, this.worker.blockPosition(), soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
            this.worker.swing(this.worker.getUsedItemHand());
        }
        if (this.timeWaited >= 25 && !this.checkedInHut && this.walkToBuilding()) {
            this.checkAndTransferFromHut(((JobLumberjack)this.job).getTree().getSapling());
            this.checkedInHut = true;
        }
        if (((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty() || this.timeWaited >= 50) {
            this.timeWaited = 0;
            this.incrementActionsDoneAndDecSaturation();
            this.setDelay(10);
            return true;
        }
        this.timeWaited += 10;
        return false;
    }

    @Override
    public void fillItemsList() {
        if (((JobLumberjack)this.job).getTree() != null) {
            this.searchForItems(new AABB(((JobLumberjack)this.job).getTree().getLocation()).expandTowards(5.0, 2.0, 5.0).expandTowards(-5.0, -2.0, -5.0));
        } else {
            this.searchForItems(this.worker.getBoundingBox().expandTowards(5.0, 2.0, 5.0).expandTowards(-5.0, -2.0, -5.0));
        }
    }

    private int findSaplingSlot() {
        for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
            ItemStack stack = this.getInventory().getStackInSlot(slot);
            if (!this.isCorrectSapling(stack)) continue;
            return slot;
        }
        return -1;
    }

    private void placeSaplings(int saplingSlot, @NotNull ItemStack stack, @NotNull Block block) {
        while (!((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty()) {
            BlockPos pos = ((JobLumberjack)this.job).getTree().getStumpLocations().get(0);
            ItemStack sapling = this.getInventory().getStackInSlot(saplingSlot);
            if (sapling.is(Tags.Items.MUSHROOMS)) {
                ((BuildingLumberjack)this.building).addNetherTree(pos);
            } else if (sapling.is(ModTags.fungi) && this.world.getBlockState(pos.below()).getBlock() instanceof NetherrackBlock) {
                Block new_block = sapling.is(Items.WARPED_FUNGUS) ? Blocks.WARPED_NYLIUM : Blocks.CRIMSON_NYLIUM;
                this.world.setBlockAndUpdate(pos.below(), new_block.defaultBlockState());
                ((BuildingLumberjack)this.building).addNetherTree(pos);
            }
            if (!(block instanceof SaplingBlock) || block.canSustainPlant(this.world.getBlockState(pos.below()), (BlockGetter)this.world, pos.below(), Direction.UP, block.defaultBlockState()).isFalse() || Objects.equals(this.world.getBlockState(pos), block.defaultBlockState())) {
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            if (this.world.setBlockAndUpdate(pos, block.defaultBlockState()) && !ItemStackUtils.isEmpty(this.getInventory().getStackInSlot(saplingSlot))) {
                this.getInventory().extractItem(saplingSlot, 1, false);
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            return;
        }
    }

    private boolean isCorrectSapling(ItemStack stack) {
        if (!ItemStackUtils.isStackSapling(stack)) {
            return false;
        }
        if (ItemStackUtils.isEmpty(((JobLumberjack)this.job).getTree().getSapling())) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)((JobLumberjack)this.job).getTree().getSapling(), (ItemStack)stack);
    }

    private IAIState gathering() {
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.hasLogs() ? RENDER_META_LOGS : "");
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getWorkingPosition(2, targetPosition, 0);
    }

    private boolean hasLogs() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), this::isStackLog);
    }
}

