/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.education;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobPupil;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.SittingEntity;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.CircleParticleEffectMessage;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPupil
extends AbstractEntityAIInteract<JobPupil, BuildingSchool> {
    private static final int STUDY_TO_RECESS_RATIO = 10;
    private final Predicate<ItemStack> PAPER = stack -> stack.getItem() == Items.PAPER;
    private int maxSittingTicks = 0;
    private int sittingTicks = 0;
    private BlockPos studyPos;

    public EntityAIWorkPupil(@NotNull JobPupil job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.STUDY, this::study, 20), new AITarget<Object>(AIWorkerState.RECESS, this::recess, 20));
        this.worker.setCanPickUpLoot(true);
    }

    private IAIState decide() {
        if (this.worker.getRandom().nextInt(10) < 1) {
            return AIWorkerState.RECESS;
        }
        BuildingSchool school = (BuildingSchool)this.building;
        BlockPos pos = school.getRandomPlaceToSit();
        if (pos == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.school.nocarpet", (Object[])new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.DECIDE;
        }
        this.studyPos = pos;
        return AIWorkerState.STUDY;
    }

    private IAIState recess() {
        if (this.worker.getNavigation().isDone() && this.worker.getRandom().nextInt(10) < 1) {
            return AIWorkerState.START_WORKING;
        }
        EntityNavigationUtils.walkToRandomPosWithin(this.worker, 10, 0.6, ((BuildingSchool)this.building).getCorners());
        return this.getState();
    }

    private IAIState study() {
        int slot;
        if (this.studyPos == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkToWorkPos(this.studyPos)) {
            return this.getState();
        }
        if (!this.world.getEntitiesOfClass(EntityCitizen.class, new AABB((double)this.studyPos.getX(), (double)this.studyPos.getY(), (double)this.studyPos.getZ(), (double)this.studyPos.getX(), (double)this.studyPos.getY(), (double)this.studyPos.getZ())).isEmpty()) {
            this.studyPos = null;
            return AIWorkerState.DECIDE;
        }
        if (this.sittingTicks == 0 || this.worker.getVehicle() == null) {
            this.maxSittingTicks = this.worker.getRandom().nextInt(60) + 60;
            SittingEntity.sitDown(this.studyPos, (Mob)this.worker, this.maxSittingTicks * 20);
        }
        if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), this.PAPER)) != -1) {
            this.worker.setItemSlot(EquipmentSlot.MAINHAND, this.worker.getInventoryCitizen().getStackInSlot(slot));
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 1.0, 0.0), ParticleTypes.ENCHANT, this.sittingTicks).sendToTrackingEntity((Entity)this.worker);
        } else {
            this.worker.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 1.0, 0.0), ParticleTypes.HAPPY_VILLAGER, this.sittingTicks).sendToTrackingEntity((Entity)this.worker);
        }
        ++this.sittingTicks;
        if (this.sittingTicks < this.maxSittingTicks) {
            return this.getState();
        }
        this.worker.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        if (this.worker.getVehicle() != null) {
            this.worker.stopRiding();
            this.worker.setPos(this.worker.getX(), this.worker.getY() + 1.0, this.worker.getZ());
        }
        if (slot != -1) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.PAPER), 1);
            double bonus = 50.0 * (1.0 + this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TEACHING));
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, bonus, this.worker.getCitizenData());
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.maxSittingTicks = 0;
        this.sittingTicks = 0;
        return null;
    }

    @Override
    public Class<BuildingSchool> getExpectedBuildingClass() {
        return BuildingSchool.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

