/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobPupil;
import com.minecolonies.core.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.core.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.core.entity.ai.minimal.EntityAIEatTask;
import com.minecolonies.core.entity.ai.minimal.EntityAIMournCitizen;
import com.minecolonies.core.entity.ai.minimal.EntityAISickTask;
import com.minecolonies.core.entity.ai.minimal.EntityAISleep;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.monster.Monster;

public class CitizenAI
implements IStateAI {
    private final EntityCitizen citizen;
    private IState lastState = CitizenAIState.IDLE;
    private List<IStateAI> minimalAI = new ArrayList<IStateAI>();

    public CitizenAI(EntityCitizen citizen) {
        this.citizen = citizen;
        citizen.getCitizenAI().addTransition(new AIEventTarget<Supplier<IState>>(AIBlockingEventType.EVENT, () -> true, this::decideAiTask, 10));
        this.registerWorkAI();
        this.minimalAI.add(new EntityAICitizenAvoidEntity(citizen, Monster.class, 5.0f, 0.8, 1.1));
        this.minimalAI.add(new EntityAIEatTask(citizen));
        this.minimalAI.add(new EntityAICitizenWander(citizen, 0.6));
        this.minimalAI.add(new EntityAISickTask(citizen));
        this.minimalAI.add(new EntityAISleep(citizen));
        this.minimalAI.add(new EntityAIMournCitizen(citizen, 0.6));
    }

    private void registerWorkAI() {
        this.citizen.getCitizenAI().addTransition(new AITarget<IState>(CitizenAIState.WORK, () -> true, () -> {
            Object ai = this.citizen.getCitizenJobHandler().getColonyJob().getWorkerAI();
            if (ai != null) {
                ai.resetAI();
            }
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return CitizenAIState.WORKING;
        }, 10));
        this.citizen.getCitizenAI().addTransition(new AITarget<IState>(CitizenAIState.WORKING, () -> true, () -> {
            Object ai;
            if (this.citizen.getCitizenJobHandler().getColonyJob() != null && (ai = this.citizen.getCitizenJobHandler().getColonyJob().getWorkerAI()) != null) {
                this.citizen.getCitizenJobHandler().getColonyJob().getWorkerAI().tick();
            }
            return CitizenAIState.WORKING;
        }, 5));
    }

    private IState decideAiTask() {
        IState next = this.calculateNextState();
        if (next == null || next == this.lastState && this.citizen.getCitizenAI().getState() != CitizenAIState.IDLE) {
            return null;
        }
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.lastState = next;
        return this.lastState;
    }

    private IState calculateNextState() {
        IJob<?> iJob = this.citizen.getCitizenJobHandler().getColonyJob();
        if (iJob instanceof AbstractJobGuard) {
            AbstractJobGuard guardJob = (AbstractJobGuard)iJob;
            if (this.shouldEat()) {
                return CitizenAIState.EATING;
            }
            if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick() && guardJob.canAIBeInterrupted()) {
                this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
                return CitizenAIState.SICK;
            }
            return CitizenAIState.WORK;
        }
        if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick() && this.citizen.getCitizenData().getCitizenDiseaseHandler().sleepsAtHospital()) {
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
            return CitizenAIState.SICK;
        }
        if (this.citizen.getCitizenColonyHandler().getColonyOrRegister().getRaiderManager().isRaided()) {
            this.citizen.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.entity.citizen.raid", (Object[])new Object[0]), ChatPriority.IMPORTANT));
            this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.RAIDED);
            return CitizenAIState.SLEEP;
        }
        if (!WorldUtil.isPastTime(CompatibilityUtils.getWorldFromCitizen(this.citizen), 10600)) {
            if (this.lastState == CitizenAIState.SLEEP) {
                this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.SLEEP);
                this.citizen.getCitizenAI().setCurrentDelay(300);
                return CitizenAIState.SLEEP;
            }
            if (this.citizen.getCitizenSleepHandler().shouldGoSleep()) {
                this.citizen.getCitizenData().onGoSleep();
                return CitizenAIState.SLEEP;
            }
        } else if (this.citizen.getCitizenSleepHandler().isAsleep()) {
            if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick()) {
                BlockPos bedPos = this.citizen.getCitizenSleepHandler().getBedLocation();
                if (bedPos == null || bedPos.distSqr((Vec3i)this.citizen.blockPosition()) > 5.0) {
                    this.citizen.getCitizenSleepHandler().onWakeUp();
                }
            } else {
                this.citizen.getCitizenSleepHandler().onWakeUp();
            }
        }
        if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick() || this.citizen.getCitizenData().getCitizenDiseaseHandler().isHurt()) {
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
            return CitizenAIState.SICK;
        }
        if (this.shouldEat()) {
            return CitizenAIState.EATING;
        }
        if (this.citizen.getCitizenData().getCitizenMournHandler().isMourning()) {
            if (this.lastState != CitizenAIState.MOURN) {
                this.citizen.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.entity.citizen.mourning", (Object[])new Object[]{this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens().iterator().next()}), (Component)Component.translatableEscape((String)"com.minecolonies.coremod.entity.citizen.mourning", (Object[])new Object[0]), ChatPriority.IMPORTANT));
                this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.MOURNING);
            }
            return CitizenAIState.MOURN;
        }
        if (CompatibilityUtils.getWorldFromCitizen(this.citizen).isRaining() && !this.shouldWorkWhileRaining() && !WorldUtil.isNetherType(this.citizen.level())) {
            this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.BAD_WEATHER);
            if (!this.citizen.getCitizenData().getColony().getRaiderManager().isRaided() && !this.citizen.getCitizenData().getCitizenMournHandler().isMourning()) {
                this.citizen.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.entity.citizen.raining", (Object[])new Object[0]), ChatPriority.HIDDEN));
            }
            return CitizenAIState.IDLE;
        }
        if (this.citizen.isBaby() && this.citizen.getCitizenJobHandler().getColonyJob() instanceof JobPupil && this.citizen.level().getDayTime() % 24000L > 6000L) {
            this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
            return CitizenAIState.IDLE;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            return CitizenAIState.WORK;
        }
        this.citizen.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
        return CitizenAIState.IDLE;
    }

    public boolean shouldEat() {
        if (this.citizen.getCitizenData().justAte()) {
            return false;
        }
        if (this.citizen.getCitizenData().getJob() != null && !this.citizen.getCitizenData().getJob().canAIBeInterrupted()) {
            return false;
        }
        if (this.lastState == CitizenAIState.EATING) {
            return true;
        }
        if (this.citizen.getCitizenData().getJob() != null && this.citizen.getCitizenData().getJob().getJobRegistryEntry() == ModJobs.cook.get() && MathUtils.RANDOM.nextInt(20) > 0) {
            return false;
        }
        if (this.citizen.getCitizenData().getCitizenDiseaseHandler().isSick() && this.citizen.getCitizenSleepHandler().isAsleep()) {
            return false;
        }
        return this.citizen.getCitizenData().getSaturation() <= 10.0 && (this.citizen.getCitizenData().getSaturation() <= 2.5 || this.citizen.getCitizenData().getSaturation() < 6.0 && (double)this.citizen.getHealth() < 6.0);
    }

    private boolean shouldWorkWhileRaining() {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).workersAlwaysWorkInRain.get()).booleanValue()) {
            return true;
        }
        ICitizenColonyHandler colonyHandler = this.citizen.getCitizenColonyHandler();
        if (colonyHandler.getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORKING_IN_RAIN) > 0.0) {
            return true;
        }
        if (colonyHandler.getWorkBuilding() != null && colonyHandler.getWorkBuilding().hasModule(WorkerBuildingModule.class)) {
            return ((WorkerBuildingModule)colonyHandler.getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class)).canWorkDuringTheRain();
        }
        return false;
    }
}

