/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.savedata.IServerColonySaveData;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;

public class CommandPruneWorld
implements IMCOPCommand {
    private static final String RADIUS_ARG = "additional block protection radius";
    private static final String COMMAND_STAGE = "stage";
    private static final String REGION_FOLDER = "region";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.tryPrune(context, 0);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.tryPrune(context, IntegerArgumentType.getInteger(context, (String)COMMAND_STAGE));
    }

    private int tryPrune(CommandContext<CommandSourceStack> context, int arg) {
        if (arg < 3) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.prune.next", (Object[])new Object[]{arg + 1}), true);
            return 0;
        }
        int radius = IntegerArgumentType.getInteger(context, (String)RADIUS_ARG);
        int deleteCount = 0;
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        File saveDir = new File(DimensionType.getStorageFolder((ResourceKey)world.dimension(), (Path)world.getServer().getWorldPath(LevelResource.ROOT)).toFile(), REGION_FOLDER);
        ArrayList<IColony> colonies = new ArrayList();
        IServerColonySaveData cap = IServerColonySaveData.getSaveData(world);
        if (cap == null) {
            return 0;
        }
        colonies = cap.getColonies();
        for (File currentRegion : saveDir.listFiles()) {
            int regionZ;
            int regionX;
            String[] split;
            if (currentRegion == null || !currentRegion.getName().contains(".mca") || (split = currentRegion.getName().split("\\.")).length != 4 || !this.isFarEnoughFromColonies(regionX = Integer.parseInt(split[1]), regionZ = Integer.parseInt(split[2]), radius, colonies)) continue;
            if (!currentRegion.delete()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Could not delete file:" + currentRegion.getPath())), true);
                continue;
            }
            ++deleteCount;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Deleted file:" + currentRegion.getPath())), true);
        }
        int finalCount = deleteCount;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Successfully deleted " + finalCount + " regions!")), true);
        return 0;
    }

    private boolean isFarEnoughFromColonies(int regionX, int regionZ, int blockRadius, List<IColony> colonies) {
        for (IColony colony : colonies) {
            for (BlockPos buildingPos : colony.getBuildingManager().getBuildings().keySet()) {
                int maxX = buildingPos.getX() + blockRadius >> 9;
                int minX = buildingPos.getX() - blockRadius >> 9;
                int maxZ = buildingPos.getZ() + blockRadius >> 9;
                int minZ = buildingPos.getZ() - blockRadius >> 9;
                if (regionX > maxX || regionX < minX || regionZ > maxZ || regionZ < minZ) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "prune-world-now";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument(COMMAND_STAGE, IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)).then(IMCCommand.newArgument(RADIUS_ARG, IntegerArgumentType.integer((int)100, (int)5000)).executes(this::executeWithPage)))).executes(this::checkPreConditionAndExecute);
    }
}

