/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.commandTypes;

import com.minecolonies.api.util.Log;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;

public interface IMCCommand {
    public static final int OP_PERM_LEVEL = 4;

    default public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).executes(this::checkPreConditionAndExecute);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> newLiteral(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> newArgument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    default public int checkPreConditionAndExecute(CommandContext<CommandSourceStack> context) {
        try {
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            return this.onExecute(context);
        }
        catch (Throwable e) {
            Log.getLogger().warn("Error during running command:", e);
            return 0;
        }
    }

    default public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).getEntity() instanceof Player || ((CommandSourceStack)context.getSource()).hasPermission(4);
    }

    public int onExecute(CommandContext<CommandSourceStack> var1);

    public String getName();

    public static boolean isPlayerOped(Player player) {
        if (player.getServer() == null) {
            return false;
        }
        return player.getServer().getPlayerList().isOp(player.getGameProfile());
    }
}

