/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.Level;

public class CommandColonyChunks
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        HashSet<TicketType> types = new HashSet<TicketType>();
        for (Long chunkLong : colony.getLoadedChunks()) {
            SortedArraySet tickets = (SortedArraySet)((CommandSourceStack)context.getSource()).getLevel().getChunkSource().chunkMap.getDistanceManager().tickets.get(chunkLong.longValue());
            if (tickets == null) continue;
            for (Ticket ticket : tickets) {
                types.add(ticket.getType());
            }
        }
        StringBuilder ticketString = new StringBuilder();
        for (TicketType type : types) {
            ticketString.append("[").append(type).append("]");
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"ID: ").append((Component)Component.literal((String)("" + colony.getID())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" Name: ")).append((Component)Component.literal((String)colony.getName()).withStyle(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Loaded chunks:").append((Component)Component.literal((String)(" " + colony.getLoadedChunkCount())).withStyle(ChatFormatting.YELLOW)), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"Ticket types: ", (Object[])new Object[0]).append((Component)Component.literal((String)ticketString.toString()).withStyle(ChatFormatting.YELLOW)), true);
        return 1;
    }

    @Override
    public String getName() {
        return "chunkstatus";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute));
    }
}

