/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CommandCitizenList
implements IMCColonyOfficerCommand {
    private static final String LIST_COMMAND_SUGGESTED = "/minecolonies citizens list %d %d";
    private static final String COMMAND_CITIZEN_INFO_SUGGESTED = "/minecolonies citizens info %d %d";
    private static final int CITIZENS_ON_PAGE = 9;

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.displayListFor(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.displayListFor(context, IntegerArgumentType.getInteger(context, (String)"startpage"));
    }

    private int displayListFor(CommandContext<CommandSourceStack> context, int page) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        List<ICitizenData> citizens = colony.getCitizenManager().getCitizens();
        int citizenCount = citizens.size();
        int halfPage = citizenCount % 9 == 0 ? 0 : 1;
        int pageCount = citizenCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, citizenCount);
        List<ICitizenData> citizensPage = this.getCitizensOnPage(citizens, citizenCount, pageStartIndex, pageStopIndex);
        MutableComponent headerLine = Component.translatableEscape((String)"com.minecolonies.command.citizenlist.pagetop", (Object[])new Object[]{page, pageCount});
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandCitizenList.lambda$displayListFor$1((Component)headerLine), true);
        this.drawCitizens(context, citizensPage);
        CommandCitizenList.drawPageSwitcher(context, page, citizenCount, halfPage, colony.getID());
        return 1;
    }

    @NotNull
    private List<ICitizenData> getCitizensOnPage(List<ICitizenData> citizens, int citizenCount, int pageStartIndex, int pageStopIndex) {
        List<ICitizenData> citizensPage = pageStartIndex < 0 || pageStartIndex >= citizenCount ? new ArrayList<ICitizenData>() : citizens.subList(pageStartIndex, pageStopIndex);
        return citizensPage;
    }

    private void drawCitizens(@NotNull CommandContext<CommandSourceStack> context, List<ICitizenData> citizensPage) {
        for (ICitizenData citizen : citizensPage) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizen.getId(), citizen.getName()}).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_CITIZEN_INFO_SUGGESTED, citizen.getColony().getID(), citizen.getId())))), true);
            citizen.getEntity().ifPresent(entityCitizen -> {
                BlockPos position = entityCitizen.blockPosition();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{position.getX(), position.getY(), position.getZ()}), true);
            });
        }
    }

    private static void drawPageSwitcher(@NotNull CommandContext<CommandSourceStack> context, int page, int count, int halfPage, int colonyId) {
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, count / 9 + halfPage);
        MutableComponent prevButton = Component.translatableEscape((String)"com.minecolonies.command.citizenlist.prev", (Object[])new Object[0]).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, prevPage))));
        MutableComponent nextButton = Component.translatableEscape((String)"com.minecolonies.command.citizenlist.next", (Object[])new Object[0]).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, nextPage))));
        MutableComponent beginLine = Component.translatableEscape((String)"com.minecolonies.command.citizenlist.pageline", (Object[])new Object[0]);
        MutableComponent endLine = Component.translatableEscape((String)"com.minecolonies.command.citizenlist.pageline", (Object[])new Object[0]);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandCitizenList.lambda$drawPageSwitcher$5(beginLine, (Component)prevButton, (Component)nextButton, endLine), true);
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)).then(IMCCommand.newArgument("startpage", IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)));
    }

    private static /* synthetic */ Component lambda$drawPageSwitcher$5(MutableComponent beginLine, Component prevButton, Component nextButton, MutableComponent endLine) {
        return beginLine.append(prevButton).append((Component)Component.translatableEscape((String)"com.minecolonies.command.citizenlist.pagestyle", (Object[])new Object[0])).append(nextButton).append((Component)endLine);
    }

    private static /* synthetic */ Component lambda$displayListFor$1(Component headerLine) {
        return headerLine;
    }
}

