/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands;

import com.minecolonies.api.util.Log;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.network.messages.client.SyncPathMessage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandEntityTrack
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return 1;
        }
        try {
            Collection entities = EntityArgument.getEntities(context, (String)"entity");
            if (entities.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.noentityfound", (Object[])new Object[0]), true);
                return 0;
            }
            Entity entity = (Entity)entities.iterator().next();
            if (PathfindingUtils.trackingMap.getOrDefault(sender.getUUID(), UUID.randomUUID()).equals(entity.getUUID())) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizentrack.success.disable"), true);
                PathfindingUtils.trackingMap.remove(sender.getUUID());
                new SyncPathMessage(new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>()).sendToPlayer((ServerPlayer)sender);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizentrack.success.enable"), true);
                PathfindingUtils.trackingMap.put(sender.getUUID(), entity.getUUID());
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            Log.getLogger().error("Error attemting to track entity", (Throwable)e);
            return 0;
        }
    }

    @Override
    public String getName() {
        return "trackPath";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("entity", EntityArgument.entities()).executes(this::checkPreConditionAndExecute));
    }
}

