/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PrivateWorkerCraftingRequestResolverFactory
implements IRequestResolverFactory<PrivateWorkerCraftingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_JOB = "Job";

    @Override
    @NotNull
    public TypeToken<? extends PrivateWorkerCraftingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(PrivateWorkerCraftingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) {
        return new PrivateWorkerCraftingRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN), (JobEntry)context[0]);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull PrivateWorkerCraftingRequestResolver privateWorkerCraftingRequestResolverFactory) {
        CompoundTag compound = new CompoundTag();
        compound.put(NBT_TOKEN, (Tag)controller.serializeTag(provider, privateWorkerCraftingRequestResolverFactory.getId()));
        compound.put(NBT_LOCATION, (Tag)controller.serializeTag(provider, privateWorkerCraftingRequestResolverFactory.getLocation()));
        compound.putString(NBT_JOB, IJobRegistry.getInstance().getKey((Object)privateWorkerCraftingRequestResolverFactory.getJobEntry()).toString());
        return compound;
    }

    @Override
    @NotNull
    public PrivateWorkerCraftingRequestResolver deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserializeTag(provider, nbt.getCompound(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserializeTag(provider, nbt.getCompound(NBT_LOCATION));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().get(ResourceLocation.parse((String)nbt.getString(NBT_JOB)));
        return new PrivateWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public void serialize(IFactoryController controller, PrivateWorkerCraftingRequestResolver input, RegistryFriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
        packetBuffer.writeById(arg_0 -> IMinecoloniesAPI.getInstance().getJobRegistry().getIdOrThrow(arg_0), (Object)input.getJobEntry());
    }

    @Override
    public PrivateWorkerCraftingRequestResolver deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        JobEntry entry = (JobEntry)buffer.readById(arg_0 -> IMinecoloniesAPI.getInstance().getJobRegistry().byIdOrThrow(arg_0));
        return new PrivateWorkerCraftingRequestResolver(location, token, entry);
    }

    @Override
    public short getSerializationId() {
        return 19;
    }
}

