/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.IRequestFactory;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.MinimumStack;
import com.minecolonies.api.colony.requestsystem.requestable.RequestTag;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestable.SmeltableOre;
import com.minecolonies.core.colony.requestsystem.requests.StandardRequests;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class StandardRequestFactories {
    private static final String NBT_REQUESTER = "Requester";
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_STATE = "State";
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_PARENT = "Parent";
    private static final String NBT_CHILDREN = "Children";
    private static final String NBT_DELIVERIES = "Deliveries";

    private StandardRequestFactories() {
    }

    public static <T extends IRequestable> CompoundTag serializeToNBT(@NotNull HolderLookup.Provider provider, IFactoryController controller, IRequest<T> request, IObjectToNBTConverter<T> typeSerialization) {
        CompoundTag compound = new CompoundTag();
        CompoundTag requesterCompound = controller.serializeTag(provider, request.getRequester());
        CompoundTag tokenCompound = controller.serializeTag(provider, request.getId());
        IntTag stateCompound = request.getState().serialize();
        CompoundTag requestedCompound = typeSerialization.apply(provider, controller, request.getRequest());
        ListTag childrenCompound = new ListTag();
        for (IToken token : request.getChildren()) {
            childrenCompound.add((Object)controller.serializeTag(provider, token));
        }
        compound.put(NBT_REQUESTER, (Tag)requesterCompound);
        compound.put(NBT_TOKEN, (Tag)tokenCompound);
        compound.put(NBT_STATE, (Tag)stateCompound);
        compound.put(NBT_REQUESTED, (Tag)requestedCompound);
        if (request.hasResult()) {
            compound.put(NBT_RESULT, (Tag)typeSerialization.apply(provider, controller, request.getResult()));
        }
        if (request.hasParent()) {
            compound.put(NBT_PARENT, (Tag)controller.serializeTag(provider, request.getParent()));
        }
        compound.put(NBT_CHILDREN, (Tag)childrenCompound);
        ListTag deliveriesList = new ListTag();
        request.getDeliveries().forEach(itemStack -> deliveriesList.add((Object)itemStack.saveOptional(provider)));
        compound.put(NBT_DELIVERIES, (Tag)deliveriesList);
        return compound;
    }

    public static <T extends IRequestable> void serializeToRegistryFriendlyByteBuf(IFactoryController controller, IRequest<T> request, RegistryFriendlyByteBuf packetBuffer, IObjectToPackBufferWriter<T> typeSerialization) {
        controller.serialize(packetBuffer, request.getRequester());
        controller.serialize(packetBuffer, request.getId());
        request.getState().serialize(packetBuffer);
        typeSerialization.apply(controller, packetBuffer, request.getRequest());
        packetBuffer.writeInt(request.getChildren().size());
        for (IToken token : request.getChildren()) {
            controller.serialize(packetBuffer, token);
        }
        packetBuffer.writeBoolean(request.hasResult());
        if (request.hasResult()) {
            typeSerialization.apply(controller, packetBuffer, request.getResult());
        }
        packetBuffer.writeBoolean(request.hasParent());
        if (request.hasParent()) {
            controller.serialize(packetBuffer, request.getParent());
        }
        packetBuffer.writeInt(request.getDeliveries().size());
        request.getDeliveries().forEach(b -> Utils.serializeCodecMess(packetBuffer, b));
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromNBT(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound, INBTToObjectConverter<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserializeTag(provider, compound.getCompound(NBT_REQUESTER));
        IToken token = (IToken)controller.deserializeTag(provider, compound.getCompound(NBT_TOKEN));
        RequestState state = RequestState.deserialize((IntTag)compound.get(NBT_STATE));
        IRequestable requested = (IRequestable)typeDeserialization.apply(provider, controller, compound.getCompound(NBT_REQUESTED));
        ArrayList<IToken> childTokens = new ArrayList<IToken>();
        ListTag childCompound = compound.getList(NBT_CHILDREN, 10);
        for (int i = 0; i < childCompound.size(); ++i) {
            childTokens.add((IToken)controller.deserializeTag(provider, childCompound.getCompound(i)));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (compound.contains(NBT_PARENT)) {
            request.setParent((IToken)controller.deserializeTag(provider, compound.getCompound(NBT_PARENT)));
        }
        if (compound.contains(NBT_RESULT)) {
            request.setResult((IRequestable)typeDeserialization.apply(provider, controller, compound.getCompound(NBT_RESULT)));
        }
        if (compound.contains(NBT_DELIVERIES)) {
            ImmutableList.Builder stackBuilder = ImmutableList.builder();
            ListTag deliveriesList = compound.getList(NBT_DELIVERIES, 10);
            NBTUtils.streamCompound(deliveriesList).forEach(itemStackCompound -> stackBuilder.add((Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemStackCompound)));
            request.overrideCurrentDeliveries((ImmutableList<ItemStack>)stackBuilder.build());
        }
        return (R)request;
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromRegistryFriendlyByteBuf(IFactoryController controller, RegistryFriendlyByteBuf buffer, IRegistryFriendlyByteBufToObjectReader<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(buffer);
        IToken token = (IToken)controller.deserialize(buffer);
        RequestState state = RequestState.deserialize(buffer);
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, buffer);
        ArrayList<IToken> childTokens = new ArrayList<IToken>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            childTokens.add((IToken)controller.deserialize(buffer));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (buffer.readBoolean()) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, buffer));
        }
        if (buffer.readBoolean()) {
            request.setParent((IToken)controller.deserialize(buffer));
        }
        ArrayList<ItemStack> deliveries = new ArrayList<ItemStack>();
        int size2 = buffer.readInt();
        for (int i = 0; i < size2; ++i) {
            deliveries.add(Utils.deserializeCodecMess(buffer));
        }
        request.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.copyOf(deliveries));
        return (R)request;
    }

    @FunctionalInterface
    public static interface IObjectToNBTConverter<O> {
        public CompoundTag apply(HolderLookup.Provider var1, IFactoryController var2, O var3);
    }

    @FunctionalInterface
    public static interface IObjectToPackBufferWriter<O> {
        public void apply(IFactoryController var1, RegistryFriendlyByteBuf var2, O var3);
    }

    @FunctionalInterface
    public static interface INBTToObjectConverter<O> {
        public O apply(HolderLookup.Provider var1, IFactoryController var2, CompoundTag var3);
    }

    @FunctionalInterface
    public static interface IObjectConstructor<T, O> {
        public O construct(@NotNull T var1, @NotNull IToken<?> var2, @NotNull IRequester var3, @NotNull RequestState var4);
    }

    @FunctionalInterface
    public static interface IRegistryFriendlyByteBufToObjectReader<O> {
        public O apply(IFactoryController var1, RegistryFriendlyByteBuf var2);
    }

    public static final class MinimumStackRequestFactory
    implements IRequestFactory<MinimumStack, StandardRequests.MinStackRequest> {
        @Override
        public StandardRequests.MinStackRequest getNewInstance(@NotNull MinimumStack input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.MinStackRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.MinStackRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.MinStackRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<MinimumStack> getFactoryInputType() {
            return TypeToken.of(MinimumStack.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.MinStackRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.MinStackRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, MinimumStack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.MinStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.MinStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.MinStackRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.MinStackRequest deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, MinimumStack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.MinStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.MinStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 60;
        }
    }

    public static final class BurnableRequestFactory
    implements IRequestFactory<Burnable, StandardRequests.BurnableRequest> {
        @Override
        public StandardRequests.BurnableRequest getNewInstance(@NotNull Burnable input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.BurnableRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.BurnableRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.BurnableRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Burnable> getFactoryInputType() {
            return TypeToken.of(Burnable.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.BurnableRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Burnable::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.BurnableRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.BurnableRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Burnable::serialize);
        }

        @Override
        public StandardRequests.BurnableRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 13;
        }
    }

    public static final class SmeltableOreRequestFactory
    implements IRequestFactory<SmeltableOre, StandardRequests.SmeltAbleOreRequest> {
        @Override
        public StandardRequests.SmeltAbleOreRequest getNewInstance(@NotNull SmeltableOre input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.SmeltAbleOreRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.SmeltAbleOreRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.SmeltAbleOreRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends SmeltableOre> getFactoryInputType() {
            return TypeToken.of(SmeltableOre.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.SmeltAbleOreRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, SmeltableOre::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.SmeltAbleOreRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.SmeltAbleOreRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, SmeltableOre::serialize);
        }

        @Override
        public StandardRequests.SmeltAbleOreRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 12;
        }
    }

    public static final class FoodRequestFactory
    implements IRequestFactory<Food, StandardRequests.FoodRequest> {
        @Override
        public StandardRequests.FoodRequest getNewInstance(@NotNull Food input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.FoodRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.FoodRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.FoodRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Food> getFactoryInputType() {
            return TypeToken.of(Food.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.FoodRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Food::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.FoodRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.FoodRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Food::serialize);
        }

        @Override
        public StandardRequests.FoodRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 11;
        }
    }

    public static final class ToolRequestFactory
    implements IRequestFactory<Tool, StandardRequests.ToolRequest> {
        @Override
        public StandardRequests.ToolRequest getNewInstance(@NotNull Tool input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ToolRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.ToolRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ToolRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Tool> getFactoryInputType() {
            return TypeToken.of(Tool.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.ToolRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Tool::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ToolRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ToolRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Tool::serialize);
        }

        @Override
        public StandardRequests.ToolRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 10;
        }
    }

    public static final class PublicCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PublicCrafting, StandardRequests.PublicCraftingRequest> {
        public PublicCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PublicCraftingRequest(requester, (IToken<?>)token, requestState, (PublicCrafting)requested), PublicCrafting.class, StandardRequests.PublicCraftingRequest.class, PublicCrafting::serialize, PublicCrafting::deserialize, PublicCrafting::serialize, PublicCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return 41;
        }
    }

    public static final class PrivateCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PrivateCrafting, StandardRequests.PrivateCraftingRequest> {
        public PrivateCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PrivateCraftingRequest(requester, (IToken<?>)token, requestState, (PrivateCrafting)requested), PrivateCrafting.class, StandardRequests.PrivateCraftingRequest.class, PrivateCrafting::serialize, PrivateCrafting::deserialize, PrivateCrafting::serialize, PrivateCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return 42;
        }
    }

    public static abstract class AbstractCraftingRequestFactory<C extends AbstractCrafting, R extends StandardRequests.AbstractCraftingRequest<C>>
    implements IRequestFactory<C, R> {
        private final IObjectConstructor<C, R> constructor;
        private final Class<C> cClass;
        private final Class<R> rClass;
        private final IObjectToNBTConverter<C> nbtSerializer;
        private final INBTToObjectConverter<C> nbtDeserializer;
        private final IObjectToPackBufferWriter<C> packetSerializer;
        private final IRegistryFriendlyByteBufToObjectReader<C> packetDeserializer;

        protected AbstractCraftingRequestFactory(IObjectConstructor<C, R> constructor, Class<C> cClass, Class<R> rClass, IObjectToNBTConverter<C> nbtSerializer, INBTToObjectConverter<C> nbtDeserializer, IObjectToPackBufferWriter<C> packetSerializer, IRegistryFriendlyByteBufToObjectReader<C> packetDeserializer) {
            this.constructor = constructor;
            this.cClass = cClass;
            this.rClass = rClass;
            this.nbtSerializer = nbtSerializer;
            this.nbtDeserializer = nbtDeserializer;
            this.packetSerializer = packetSerializer;
            this.packetDeserializer = packetDeserializer;
        }

        @Override
        public R getNewInstance(@NotNull C input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return (R)((StandardRequests.AbstractCraftingRequest)this.constructor.construct(input, token, location, initialState));
        }

        @Override
        @NotNull
        public TypeToken<? extends R> getFactoryOutputType() {
            return TypeToken.of(this.rClass);
        }

        @Override
        @NotNull
        public TypeToken<? extends C> getFactoryInputType() {
            return TypeToken.of(this.cClass);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull R r) {
            return StandardRequestFactories.serializeToNBT(provider, controller, r, this.nbtSerializer);
        }

        @Override
        @NotNull
        public R deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, this.nbtDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, R input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, this.packetSerializer);
        }

        @Override
        public R deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, this.packetDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class PickupRequestFactory
    implements IRequestFactory<Pickup, StandardRequests.PickupRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.PickupRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.PickupRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Pickup> getFactoryInputType() {
            return TypeConstants.PICKUP;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.PickupRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Pickup::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.PickupRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.PickupRequest getNewInstance(@NotNull Pickup input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.PickupRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.PickupRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Pickup::serialize);
        }

        @Override
        public StandardRequests.PickupRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 9;
        }
    }

    public static final class DeliveryRequestFactory
    implements IRequestFactory<Delivery, StandardRequests.DeliveryRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.DeliveryRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.DeliveryRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Delivery> getFactoryInputType() {
            return TypeConstants.DELIVERY;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.DeliveryRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Delivery::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.DeliveryRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.DeliveryRequest getNewInstance(@NotNull Delivery input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.DeliveryRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.DeliveryRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Delivery::serialize);
        }

        @Override
        public StandardRequests.DeliveryRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 8;
        }
    }

    public static final class ItemTagRequestFactory
    implements IRequestFactory<RequestTag, StandardRequests.ItemTagRequest> {
        @Override
        public StandardRequests.ItemTagRequest getNewInstance(@NotNull RequestTag input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemTagRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemTagRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemTagRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<RequestTag> getFactoryInputType() {
            return TypeToken.of(RequestTag.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, RequestTag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, RequestTag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest itemTagRequest, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, itemTagRequest, packetBuffer, RequestTag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, RequestTag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 7;
        }
    }

    public static final class ItemStackListRequestFactory
    implements IRequestFactory<StackList, StandardRequests.ItemStackListRequest> {
        @Override
        public StandardRequests.ItemStackListRequest getNewInstance(@NotNull StackList input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackListRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackListRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackListRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<StackList> getFactoryInputType() {
            return TypeToken.of(StackList.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackListRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, StackList::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackListRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ItemStackListRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, StackList::serialize);
        }

        @Override
        public StandardRequests.ItemStackListRequest deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 6;
        }
    }

    public static final class ItemStackRequestFactory
    implements IRequestFactory<Stack, StandardRequests.ItemStackRequest> {
        @Override
        public StandardRequests.ItemStackRequest getNewInstance(@NotNull Stack input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Stack> getFactoryInputType() {
            return TypeToken.of(Stack.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest request) {
            return StandardRequestFactories.serializeToNBT(provider, controller, request, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(provider, controller, nbt, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest input, RegistryFriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToRegistryFriendlyByteBuf(controller, input, packetBuffer, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromRegistryFriendlyByteBuf(controller, buffer, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 5;
        }
    }
}

