/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class EntityLocation
implements ILocation {
    @NotNull
    private final UUID uuid;
    @NotNull
    private WeakReference<Entity> entity = new WeakReference<Object>(null);

    public EntityLocation(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.checkEntity();
    }

    private void checkEntity() {
        if (this.entity.get() != null) {
            return;
        }
        for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
            try {
                Entity ent = world.getEntity(this.uuid);
                if (ent == null) continue;
                this.entity = new WeakReference<Entity>(ent);
                return;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        if (entityRef == null) {
            return BlockPos.ZERO;
        }
        return entityRef.blockPosition();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getDimension() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        if (entityRef == null) {
            return Level.OVERWORLD;
        }
        return entityRef.getCommandSenderWorld().dimension();
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        this.checkEntity();
        return this.entity != null && this.entity.get() != null && location.getDimension() == this.getDimension();
    }

    public Player getPlayerEntity() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        return entityRef instanceof Player ? (Player)entityRef : null;
    }

    public static void serialize(RegistryFriendlyByteBuf buffer, EntityLocation location) {
        buffer.writeUUID(location.uuid);
    }

    public static EntityLocation deserialize(RegistryFriendlyByteBuf buffer) {
        UUID uuid = buffer.readUUID();
        return new EntityLocation(uuid);
    }

    public static class Factory
    implements ILocationFactory<Entity, EntityLocation> {
        private static final String NBT_MSB = "Id_MSB";
        private static final String NBT_LSB = "Id_LSB";

        @Override
        @NotNull
        public TypeToken<EntityLocation> getFactoryOutputType() {
            return TypeToken.of(EntityLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<Entity> getFactoryInputType() {
            return TypeToken.of(Entity.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull EntityLocation request) {
            CompoundTag compound = new CompoundTag();
            compound.putLong(NBT_LSB, request.uuid.getLeastSignificantBits());
            compound.putLong(NBT_MSB, request.uuid.getMostSignificantBits());
            return compound;
        }

        @Override
        @NotNull
        public EntityLocation deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            UUID uuid = new UUID(nbt.getLong(NBT_MSB), nbt.getLong(NBT_LSB));
            return new EntityLocation(uuid);
        }

        @Override
        @NotNull
        public EntityLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull Entity input) {
            return new EntityLocation(input.getUUID());
        }

        @Override
        public void serialize(IFactoryController controller, EntityLocation input, RegistryFriendlyByteBuf packetBuffer) {
            EntityLocation.serialize(packetBuffer, input);
        }

        @Override
        public EntityLocation deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            return EntityLocation.deserialize(buffer);
        }

        @Override
        public short getSerializationId() {
            return 4;
        }
    }
}

