/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StatisticsManager
implements IStatisticsManager {
    private static final String TAG_STAT_MANAGER = "stat_manager";
    private static final String TAG_STAT = "stat";
    private final Map<String, Int2IntLinkedOpenHashMap> stats = new HashMap<String, Int2IntLinkedOpenHashMap>();
    private Set<String> dirtyStats = new HashSet<String>();

    @Override
    public void increment(@NotNull String id, int day) {
        this.incrementBy(id, 1, day);
    }

    @Override
    public void incrementBy(@NotNull String id, int qty, int day) {
        Int2IntLinkedOpenHashMap innerMap = this.stats.computeIfAbsent(id, k -> new Int2IntLinkedOpenHashMap());
        innerMap.addTo(day, qty);
        this.dirtyStats.add(id);
    }

    @Override
    public int getStatTotal(@NotNull String id) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int totalCount = 0;
        IntIterator intIterator = stats.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            totalCount += count;
        }
        return totalCount;
    }

    @Override
    public int getStatsInPeriod(@NotNull String id, int startDay, int endDay) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int count = 0;
        for (int day = startDay; day <= endDay; ++day) {
            count += stats.get(day);
        }
        return count;
    }

    @Override
    @NotNull
    public Set<String> getStatTypes() {
        return this.stats.keySet();
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf, boolean fullSync) {
        buf.writeBoolean(fullSync);
        buf.writeVarInt(fullSync ? this.stats.size() : this.dirtyStats.size());
        if (fullSync) {
            for (Map.Entry<String, Int2IntLinkedOpenHashMap> dataEntry : this.stats.entrySet()) {
                buf.writeUtf(dataEntry.getKey());
                buf.writeVarInt(dataEntry.getValue().size());
                for (Int2IntMap.Entry valueEntry : dataEntry.getValue().int2IntEntrySet()) {
                    buf.writeVarInt(valueEntry.getIntKey());
                    buf.writeVarInt(valueEntry.getIntValue());
                }
            }
        } else {
            for (String id : this.dirtyStats) {
                Int2IntLinkedOpenHashMap dataEntry = this.stats.get(id);
                buf.writeUtf(id);
                buf.writeVarInt(1);
                buf.writeVarInt(dataEntry.lastIntKey());
                buf.writeVarInt(dataEntry.get(dataEntry.lastIntKey()));
            }
        }
        if (!this.dirtyStats.isEmpty()) {
            this.dirtyStats = new HashSet<String>();
        }
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        boolean fullSync = buf.readBoolean();
        if (fullSync) {
            this.stats.clear();
        }
        int statSize = buf.readVarInt();
        for (int i = 0; i < statSize; ++i) {
            String id = buf.readUtf();
            int statEntrySize = buf.readVarInt();
            Int2IntLinkedOpenHashMap statValues = fullSync || !this.stats.containsKey(id) ? new Int2IntLinkedOpenHashMap(statEntrySize) : this.stats.get(id);
            for (int j = 0; j < statEntrySize; ++j) {
                statValues.put(buf.readVarInt(), buf.readVarInt());
            }
            this.stats.put(id, statValues);
        }
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        ListTag statManagerNBT = new ListTag();
        for (Map.Entry<String, Int2IntLinkedOpenHashMap> stat : this.stats.entrySet()) {
            CompoundTag statCompound = new CompoundTag();
            statCompound.putString("id", stat.getKey());
            ListTag statNBT = new ListTag();
            for (Int2IntMap.Entry dailyStats : stat.getValue().int2IntEntrySet()) {
                CompoundTag timeStampTag = new CompoundTag();
                timeStampTag.putInt("time", dailyStats.getIntKey());
                timeStampTag.putInt("quantity", dailyStats.getIntValue());
                statNBT.add((Object)timeStampTag);
            }
            statCompound.put(TAG_STAT, (Tag)statNBT);
            statManagerNBT.add((Object)statCompound);
        }
        compound.put(TAG_STAT_MANAGER, (Tag)statManagerNBT);
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        this.stats.clear();
        if (compound.contains(TAG_STAT_MANAGER)) {
            ListTag statsNbts = compound.getList(TAG_STAT_MANAGER, 10);
            for (int i = 0; i < statsNbts.size(); ++i) {
                CompoundTag statCompound = statsNbts.getCompound(i);
                String id = statCompound.getString("id");
                ListTag timeStampNbts = statCompound.getList(TAG_STAT, 10);
                Int2IntLinkedOpenHashMap timeStamps = new Int2IntLinkedOpenHashMap();
                for (int j = 0; j < timeStampNbts.size(); ++j) {
                    CompoundTag compoundTag = timeStampNbts.getCompound(j);
                    int day = compoundTag.getInt("time");
                    int qty = compoundTag.getInt("quantity");
                    timeStamps.put(day, qty);
                }
                this.stats.put(id, timeStamps);
            }
        }
    }
}

