/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingStatisticsModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.production.herders.EntityAIWorkChickenHerder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobChickenHerder
extends AbstractJob<EntityAIWorkChickenHerder, JobChickenHerder> {
    public JobChickenHerder(ICitizenData entity) {
        super(entity);
    }

    @Override
    @Nullable
    public EntityAIWorkChickenHerder generateAI() {
        return new EntityAIWorkChickenHerder(this);
    }

    @Override
    public boolean pickupSuccess(@NotNull ItemStack pickedUpStack) {
        if (pickedUpStack.getItem() == Items.FEATHER || pickedUpStack.getItem() == Items.EGG) {
            return this.getCitizen().getRandom().nextInt(this.getCitizen().getCitizenSkillHandler().getLevel(((WorkerBuildingModule)this.getCitizen().getWorkBuilding().getModule(BuildingModules.CHICKENHERDER_WORK)).getPrimarySkill())) > 1;
        }
        return true;
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.CHICKEN_FARMER_ID;
    }

    @Override
    public boolean onStackPickUp(@NotNull ItemStack pickedUpStack) {
        if (this.getCitizen().getWorkBuilding() != null && this.getCitizen().getEntity().isPresent() && this.getCitizen().getWorkBuilding().isInBuilding(this.getCitizen().getEntity().get().blockPosition())) {
            ((BuildingStatisticsModule)this.getCitizen().getWorkBuilding().getModule(BuildingModules.STATS_MODULE)).incrementBy("item_used;" + pickedUpStack.getItem().getDescriptionId(), pickedUpStack.getCount());
        }
        return super.onStackPickUp(pickedUpStack);
    }
}

