/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.specific;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic.BoneMealedPlantModule;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class SeapicklePlantModule
extends BoneMealedPlantModule {
    private static final int MAX_PLANTS = 10;

    public SeapicklePlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workPosition) {
        BlockState state = world.getBlockState(workPosition.above());
        if (state.getBlock().equals(Blocks.WATER)) {
            return new IPlantationModule.PlantationModuleResult.Builder().plant(workPosition.above()).pickNewPosition();
        }
        return super.decideFieldWork(world, workPosition);
    }

    @Override
    protected boolean isValidHarvestBlock(BlockState blockState) {
        if (blockState.getBlock() instanceof SeaPickleBlock) {
            Integer value = (Integer)blockState.getValue((Property)SeaPickleBlock.PICKLES);
            return value >= 4;
        }
        return super.isValidHarvestBlock(blockState);
    }

    @Override
    protected boolean isValidBonemealLocation(BlockState blockState) {
        if (blockState.getBlock() instanceof SeaPickleBlock) {
            Integer value = (Integer)blockState.getValue((Property)SeaPickleBlock.PICKLES);
            return value < 4;
        }
        return super.isValidBonemealLocation(blockState);
    }

    @Override
    protected int getMaxWorkingPositions() {
        return 10;
    }

    @Override
    public @NonNull List<Item> getValidBonemeal() {
        return List.of(Items.BONE_MEAL);
    }

    @Override
    public void applyBonemeal(AbstractEntityCitizen worker, BlockPos workPosition, ItemStack stackInSlot, Player fakePlayer) {
        BoneMealItem.applyBonemeal((ItemStack)stackInSlot, (Level)worker.level(), (BlockPos)workPosition.above(), (Player)fakePlayer);
        BoneMealItem.addGrowthParticles((LevelAccessor)worker.level(), (BlockPos)workPosition.above(), (int)1);
    }
}

