/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.AbstractPlantationModule;
import com.minecolonies.core.util.CollectorUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PercentageHarvestPlantModule
extends AbstractPlantationModule {
    protected PercentageHarvestPlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workingPosition) {
        IPlantationModule.ActionToPerform action = this.decideWorkAction(world, workingPosition);
        return switch (action) {
            case IPlantationModule.ActionToPerform.HARVEST -> new IPlantationModule.PlantationModuleResult.Builder().harvest(workingPosition).pickNewPosition();
            case IPlantationModule.ActionToPerform.PLANT -> new IPlantationModule.PlantationModuleResult.Builder().plant(workingPosition).pickNewPosition();
            case IPlantationModule.ActionToPerform.CLEAR -> new IPlantationModule.PlantationModuleResult.Builder().clear(workingPosition).pickNewPosition();
            default -> IPlantationModule.PlantationModuleResult.NONE;
        };
    }

    private IPlantationModule.ActionToPerform decideWorkAction(Level world, BlockPos plantingPosition) {
        BlockState blockState = world.getBlockState(plantingPosition);
        if (this.isValidPlantingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.PLANT;
        }
        if (this.isValidClearingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.CLEAR;
        }
        if (this.isValidHarvestBlock(blockState)) {
            return IPlantationModule.ActionToPerform.HARVEST;
        }
        return IPlantationModule.ActionToPerform.NONE;
    }

    protected boolean isValidPlantingBlock(BlockState blockState) {
        return blockState.isAir();
    }

    protected boolean isValidClearingBlock(BlockState blockState) {
        return !this.isValidHarvestBlock(blockState);
    }

    protected abstract boolean isValidHarvestBlock(BlockState var1);

    @Override
    @Nullable
    public BlockPos getNextWorkingPosition(Level world) {
        List workingPositions = this.getWorkingPositions().stream().collect(CollectorUtils.toShuffledList());
        ArrayList<BlockPos> harvestablePositions = new ArrayList<BlockPos>();
        double minimumPlantFraction = (double)Mth.clamp((int)this.getMinimumPlantPercentage(), (int)0, (int)100) / 100.0;
        int minimumPlantCount = (int)Math.ceil(minimumPlantFraction * (double)workingPositions.size());
        for (BlockPos position : workingPositions) {
            IPlantationModule.ActionToPerform action = this.decideWorkAction(world, position);
            if (action == IPlantationModule.ActionToPerform.CLEAR) {
                return position;
            }
            if (action != IPlantationModule.ActionToPerform.HARVEST) continue;
            harvestablePositions.add(position);
        }
        if (minimumPlantCount > harvestablePositions.size()) {
            Set excludedPositions = harvestablePositions.stream().flatMap(f -> Stream.of(f, f.above(), f.below(), f.north(), f.south(), f.west(), f.east())).collect(Collectors.toSet());
            return workingPositions.stream().filter(f -> !excludedPositions.contains(f)).findFirst().orElse(null);
        }
        if (minimumPlantCount < harvestablePositions.size()) {
            HashSet duplicateLocator = new HashSet();
            return harvestablePositions.stream().flatMap(f -> Stream.of(f, f.above(), f.below(), f.north(), f.south(), f.west(), f.east())).filter(f -> !duplicateLocator.add(f)).findFirst().orElse((BlockPos)harvestablePositions.get(0));
        }
        return null;
    }

    @Override
    public int getActionLimit() {
        return 5;
    }

    @Override
    public List<ItemStack> getRequiredItemsForOperation() {
        return List.of(new ItemStack((ItemLike)this.getItem()));
    }

    protected abstract int getMinimumPlantPercentage();

    @Override
    public BlockPos getPositionToWalkTo(Level world, BlockPos workingPosition) {
        return Stream.of(workingPosition.north(), workingPosition.south(), workingPosition.west(), workingPosition.east()).filter(pos -> world.getBlockState(pos).isAir()).findFirst().orElse(workingPosition);
    }
}

