/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingGlassblower
extends AbstractBuilding {
    protected static final String GLASS_BLOWER = "glassblower";
    private static final String GLASS_BLOWER_SMELTING = "glassblower_smelting";

    public BuildingGlassblower(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return GLASS_BLOWER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class DOCraftingModule
    extends AbstractCraftingBuildingModule.Domum {
        public DOCraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @NotNull
        public static OptionalPredicate<ItemStack> getStaticIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER, true);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return DOCraftingModule.getStaticIngredientValidator();
        }
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER_SMELTING).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_GLASSBLOWER_SMELTING).orElse(false);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_GLASSBLOWER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_GLASSBLOWER).orElse(false);
        }
    }
}

