/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingDyer
extends AbstractBuilding {
    private static final String DYER = "dyer";

    public BuildingDyer(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DYER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_DYER_SMELTING).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_DYER_SMELTING).orElse(false);
        }

        @Override
        public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        private List<ItemStorage> woolItems;

        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_DYER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_DYER).orElse(false);
        }

        @Override
        public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            List<TagKey> dyes = List.of(Tags.Items.DYES_WHITE, Tags.Items.DYES_ORANGE, Tags.Items.DYES_MAGENTA, Tags.Items.DYES_LIGHT_BLUE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_LIME, Tags.Items.DYES_PINK, Tags.Items.DYES_GRAY, Tags.Items.DYES_LIGHT_GRAY, Tags.Items.DYES_CYAN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_BLUE, Tags.Items.DYES_BROWN, Tags.Items.DYES_GREEN, Tags.Items.DYES_RED, Tags.Items.DYES_BLACK);
            for (ItemStack item : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
                Item item2 = item.getItem();
                if (!(item2 instanceof ArmorItem)) continue;
                ArmorItem armorItem = (ArmorItem)item2;
                if (!item.has(DataComponents.DYED_COLOR)) continue;
                for (TagKey dyeTag : dyes) {
                    DyeItem dye;
                    ItemStack result;
                    Item item3;
                    List<ItemStack> dyeItems = ((HolderSet.Named)BuiltInRegistries.ITEM.getTag(dyeTag).get()).stream().map(ItemStack::new).toList();
                    if (dyeItems.isEmpty() || !((item3 = dyeItems.get(0).getItem()) instanceof DyeItem) || (result = DyedItemColor.applyDyes((ItemStack)item, List.of(dye = (DyeItem)item3))).isEmpty()) continue;
                    recipes.add(new GenericRecipe(null, result, List.of(), List.of(List.of(item), dyeItems), 2, Blocks.AIR, null, (EquipmentTypeEntry)ModEquipmentTypes.none.get(), List.of(), 0));
                }
            }
            return recipes;
        }

        @Override
        public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
            IRecipeStorage recipe = super.getFirstRecipe(stackPredicate);
            if (recipe == null && stackPredicate.test(new ItemStack((ItemLike)Items.WHITE_WOOL))) {
                HashMap<ItemStorage, Integer> inventoryCounts = new HashMap<ItemStorage, Integer>();
                if (!this.building.getColony().getBuildingManager().hasWarehouse()) {
                    return null;
                }
                for (ItemStorage color : this.getWoolItems()) {
                    for (IBuilding iBuilding : this.building.getColony().getBuildingManager().getWareHouses()) {
                        int colorCount = InventoryUtils.getCountFromBuilding(iBuilding, color);
                        inventoryCounts.put(color, inventoryCounts.getOrDefault(color, 0) + colorCount);
                    }
                }
                ItemStorage woolToUse = (ItemStorage)inventoryCounts.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
                IToken<?> token = this.getTokenForWool(woolToUse);
                recipe = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
            }
            return recipe;
        }

        @Override
        public boolean holdsRecipe(IToken<?> token) {
            if (super.holdsRecipe(token)) {
                return true;
            }
            IRecipeStorage recipe = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
            if (recipe == null) {
                return false;
            }
            return recipe.getPrimaryOutput().getItem() == Items.WHITE_WOOL;
        }

        @Override
        public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
            IRecipeStorage recipe = super.getFirstFulfillableRecipe(stackPredicate, count, considerReservation);
            if (recipe == null && stackPredicate.test(new ItemStack((ItemLike)Items.WHITE_WOOL))) {
                HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
                for (ICitizenData workerEntity : this.building.getAllAssignedCitizen()) {
                    handlers.add(workerEntity.getInventory());
                }
                for (ItemStorage color : this.getWoolItems()) {
                    IToken<?> token = this.getTokenForWool(color);
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                    IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
                    if (!toTest.canFullFillRecipe(count, considerReservation ? this.reservedStacks() : Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) continue;
                    return toTest;
                }
            }
            return recipe;
        }

        private List<ItemStorage> getWoolItems() {
            if (this.woolItems == null) {
                this.woolItems = BuiltInRegistries.ITEM.getOrCreateTag(ItemTags.WOOL).stream().filter(item -> !((Item)item.value()).equals(Items.WHITE_WOOL)).map(i -> new ItemStorage(new ItemStack(i))).collect(Collectors.toList());
            }
            return this.woolItems;
        }

        private IToken<?> getTokenForWool(ItemStorage wool) {
            IRecipeStorage tempRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)wool, (Object)new ItemStorage(new ItemStack((ItemLike)Items.WHITE_DYE, 1))), 1, new ItemStack((ItemLike)Items.WHITE_WOOL, 1), Blocks.AIR});
            return IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(tempRecipe);
        }
    }
}

