/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.core.client.gui.modules.GraveyardManagementWindow;
import com.minecolonies.core.tileentities.TileEntityGrave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class GraveyardManagementModuleView
extends AbstractBuildingModuleView {
    @NotNull
    private List<BlockPos> graves = new ArrayList<BlockPos>();
    @NotNull
    private List<String> restingCitizen = new ArrayList<String>();

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.graves = new ArrayList<BlockPos>();
        int size = buf.readInt();
        for (int i = 1; i <= size; ++i) {
            @NotNull BlockPos pos = buf.readBlockPos();
            this.graves.add(pos);
        }
        this.restingCitizen = new ArrayList<String>();
        int sizeRIP = buf.readInt();
        for (int i = 1; i <= sizeRIP; ++i) {
            this.restingCitizen.add(buf.readUtf());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new GraveyardManagementWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "grave";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.gui.workerhuts.enchanter.workers";
    }

    @NotNull
    public List<BlockPos> getGraves() {
        return this.graves;
    }

    public void cleanGraves() {
        for (BlockPos grave : new ArrayList<BlockPos>(this.graves)) {
            BlockEntity entity = this.buildingView.getColony().getWorld().getBlockEntity(grave);
            if (entity instanceof TileEntityGrave) continue;
            this.graves.remove(grave);
        }
    }

    @NotNull
    public List<String> getRestingCitizen() {
        return Collections.unmodifiableList(this.restingCitizen);
    }
}

