/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.CitizenDataView;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VisitorDataView
extends CitizenDataView
implements IVisitorViewData {
    private ItemStack recruitmentCosts;
    private volatile ResourceLocation cachedTexture;

    public VisitorDataView(int id, IColonyView colony) {
        super(id, colony);
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.recruitmentCosts = Utils.deserializeCodecMess(buf);
        this.recruitmentCosts.setCount(buf.readInt());
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitmentCosts;
    }

    @Override
    public ResourceLocation getCustomTexture() {
        if (this.textureUUID == null) {
            return null;
        }
        if (this.cachedTexture == null) {
            this.cachedTexture = DefaultPlayerSkin.get((UUID)this.textureUUID).texture();
            Util.backgroundExecutor().execute(() -> {
                ResourceLocation newTexture;
                Minecraft minecraft = Minecraft.getInstance();
                ProfileResult profile = minecraft.getMinecraftSessionService().fetchProfile(this.textureUUID, true);
                if (profile != null && (newTexture = minecraft.getSkinManager().getInsecureSkin(profile.profile()).texture()) != null) {
                    this.cachedTexture = newTexture;
                }
            });
        }
        return this.cachedTexture;
    }
}

