/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.client.render.worldevent.highlightmanager.IHighlightRenderData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HighlightManager {
    private static final Map<String, HighlightRenderDataContainer> HIGHLIGHT_ITEMS = new HashMap<String, HighlightRenderDataContainer>();

    static void render(WorldEventContext context) {
        if (HIGHLIGHT_ITEMS.isEmpty()) {
            return;
        }
        long worldTime = context.clientLevel.getGameTime();
        ArrayList<HighlightRenderDataContainer> itemsToRemove = new ArrayList<HighlightRenderDataContainer>();
        for (HighlightRenderDataContainer renderDataContainer : HIGHLIGHT_ITEMS.values()) {
            renderDataContainer.attemptStart(context);
            IHighlightRenderData renderData = renderDataContainer.data;
            if (renderDataContainer.isExpired(worldTime)) {
                renderData.stopRender(context);
                itemsToRemove.add(renderDataContainer);
                continue;
            }
            renderData.render(context);
        }
        for (HighlightRenderDataContainer container : itemsToRemove) {
            HIGHLIGHT_ITEMS.remove(container.key);
        }
    }

    public static void clearHighlightsForKey(String key) {
        HIGHLIGHT_ITEMS.remove(key);
    }

    public static void addHighlight(String key, IHighlightRenderData data) {
        HIGHLIGHT_ITEMS.put(key, new HighlightRenderDataContainer(key, data));
    }

    private static class HighlightRenderDataContainer {
        private final String key;
        private final IHighlightRenderData data;
        private long startTime = 0L;

        private HighlightRenderDataContainer(String key, IHighlightRenderData data) {
            this.key = key;
            this.data = data;
        }

        private boolean isExpired(long worldTime) {
            Duration duration = this.data.getDuration();
            if (duration != null) {
                return this.startTime + duration.getSeconds() * 20L < worldTime;
            }
            return false;
        }

        private void attemptStart(WorldEventContext context) {
            if (this.startTime == 0L) {
                this.startTime = context.clientLevel.getGameTime();
                this.data.startRender(context);
            }
        }
    }
}

