/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.model;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;

public class MaleCourierModel
extends CitizenModel<AbstractEntityCitizen> {
    public MaleCourierModel(ModelPart root) {
        super(root);
        this.hat.visible = false;
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bipedHead = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -3.6148f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-4.0f, -7.0f, -3.6148f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.1f, (float)-2.3f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition shortBeard = bipedHead.addOrReplaceChild("shortBeard", CubeListBuilder.create().texOffs(24, 0).addBox(-3.5f, -23.1f, -5.9f, 7.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 4).addBox(-3.5f, -22.1f, -5.9f, 7.0f, 3.0f, 1.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)24.1f, (float)2.3f));
        PartDefinition bipedBody = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -11.35f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 32).addBox(-4.0f, -11.35f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition backpack = bipedBody.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(100, 50).addBox(-4.0f, -1.7f, 0.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)-7.4f, (float)2.3f));
        PartDefinition lid_r1 = backpack.addOrReplaceChild("lid_r1", CubeListBuilder.create().texOffs(100, 42).addBox(-4.0f, -1.2f, -0.5f, 8.0f, 2.0f, 6.0f, new CubeDeformation(0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.1f, (float)0.6f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bipedRightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -1.5f, -2.3f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 32).addBox(-3.0f, -1.5f, -2.3f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)-1.6f));
        PartDefinition bipedLeftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -1.5f, -2.3f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 48).addBox(-1.0f, -1.5f, -2.3f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)2.5f, (float)-1.6f));
        PartDefinition bipedRightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition bipedLeftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    public float getActualRotation(@NotNull AbstractEntityCitizen entity) {
        return entity.getPose() == Pose.SLEEPING || !entity.getRenderMetadata().contains("backpack") ? 0.0f : 0.1745f;
    }

    @Override
    public void setupAnim(@NotNull AbstractEntityCitizen entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.body.y += 12.0f;
        boolean showBackPack = entity.getPose() != Pose.SLEEPING && entity.getRenderMetadata().contains("backpack");
        this.head.z = showBackPack ? -2.1f : 0.0f;
        this.body.getChild((String)"backpack").visible = showBackPack;
        this.leftArm.y = showBackPack ? 2.0f : 2.5f;
        this.rightArm.y = showBackPack ? 2.0f : 2.5f;
    }
}

