/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.questlog;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestTemplate;
import com.minecolonies.core.client.gui.questlog.Constants;
import com.minecolonies.core.client.gui.questlog.WindowQuestLogQuestModule;
import com.minecolonies.core.client.render.worldevent.HighlightManager;
import com.minecolonies.core.client.render.worldevent.highlightmanager.CitizenRenderData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class WindowQuestLogInProgressQuestQuestModule
implements WindowQuestLogQuestModule<IQuestInstance> {
    @Override
    public List<IQuestInstance> getQuestItems(IColonyView colonyView) {
        return colonyView.getQuestManager().getInProgressQuests();
    }

    @Override
    public void renderQuestItem(IQuestInstance quest, IColonyView colonyView, Pane row) {
        IQuestTemplate questTemplate = IQuestManager.GLOBAL_SERVER_QUESTS.get(quest.getId());
        this.setText(row, "questName", (Component)Component.translatableEscape((String)"com.minecolonies.coremod.item.questlog.gui.name_prefix", (Object[])new Object[0]).append(questTemplate.getName()));
        this.setText(row, "questGiver", (Component)Component.translatableEscape((String)"com.minecolonies.coremod.item.questlog.gui.giver_prefix", (Object[])new Object[0]).append(this.getQuestGiverName(colonyView, quest)));
        IQuestObjectiveTemplate objectiveTemplate = questTemplate.getObjective(quest.getObjectiveIndex());
        Text questObjectiveText = (Text)row.findPaneOfTypeByID("questObjective", Text.class);
        Component progressText = objectiveTemplate.getProgressText(quest, Style.EMPTY.withColor(ChatFormatting.GOLD));
        MutableComponent mainComponent = Component.literal((String)" - ").append(progressText).withStyle(ChatFormatting.GOLD);
        questObjectiveText.setText((Component)mainComponent);
        ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(objectiveTemplate.getProgressText(quest, Style.EMPTY.withColor(ChatFormatting.WHITE)))).hoverPane((Pane)questObjectiveText).build();
    }

    @Override
    public void trackQuest(IQuestInstance quest) {
        HighlightManager.addHighlight("questLogTracking", new CitizenRenderData(quest.getQuestTarget(), Constants.HIGHLIGHT_QUEST_LOG_TRACKER_DURATION));
    }

    private void setText(Pane container, String id, Component component) {
        Text label = (Text)container.findPaneOfTypeByID(id, Text.class);
        label.setText(component);
        if (label.getRenderedTextWidth() > label.getWidth()) {
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(component)).hoverPane((Pane)label).build();
        }
    }

    private Component getQuestGiverName(IColonyView colonyView, IQuestInstance quest) {
        ICitizenDataView citizen = colonyView.getCitizen(quest.getQuestTarget());
        if (citizen != null) {
            return Component.literal((String)citizen.getName());
        }
        return Component.empty();
    }
}

