/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.map;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import com.minecolonies.api.client.render.modeltype.ISimpleModelType;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.map.ColonySize;
import com.minecolonies.core.client.gui.map.MinecraftMap;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.colony.ColonyListMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class WindowColonyMap
extends AbstractWindowSkeleton {
    private static final int MAP_ZOOM = 2;
    private static final int MAP_SIZE = 256;
    private static final String WINDOW_RESOURCE = ":gui/map/windowcolonymap.xml";
    private static final double COLONY_DETAIL_SCALE = 0.3;
    private static List<ColonyListMessage.ColonyInfo> colonies = new ArrayList<ColonyListMessage.ColonyInfo>();
    private final BlockPos playerPos;
    private final ZoomDragView dragView;
    private Map<ICitizenDataView, Pane> citizens = new HashMap<ICitizenDataView, Pane>();
    private Map<IBuildingView, ItemIcon> buildings = new HashMap<IBuildingView, ItemIcon>();
    private Map<ColonyListMessage.ColonyInfo, View> coloniesImages = new HashMap<ColonyListMessage.ColonyInfo, View>();
    private ITownHallView building;
    private final DecimalFormat scaleformet = new DecimalFormat("##");
    private double currentScale = 0.0;
    private final boolean hasMaps;
    private final BlockPos worldPosRoot;

    public WindowColonyMap(ITownHallView building) {
        super("minecolonies:gui/map/windowcolonymap.xml");
        this.building = building;
        this.playerPos = Minecraft.getInstance().player.blockPosition();
        this.dragView = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        this.hasMaps = !building.getMapDataList().isEmpty();
        this.findPaneByID("warning").setVisible(!this.hasMaps);
        if (this.hasMaps) {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxScale = 0;
            for (ITownHallView.MapEntry entry : building.getMapDataList()) {
                int scale = 1 << entry.mapData().scale;
                maxScale = Math.max(maxScale, scale);
                minX = Math.min(minX, entry.mapData().centerX - 64 * scale);
                maxX = Math.max(maxX, entry.mapData().centerX + 64 * scale);
                minZ = Math.min(minZ, entry.mapData().centerZ - 64 * scale);
                maxZ = Math.max(maxZ, entry.mapData().centerZ + 64 * scale);
            }
            this.worldPosRoot = new BlockPos(minX - 256 * maxScale, 0, minZ - 256 * maxScale);
            this.addMaps();
            MinecraftMap bottomRightFake = new MinecraftMap();
            bottomRightFake.setSize(256 * maxScale, 256 * maxScale);
            bottomRightFake.setID("mapBottomRight" + maxX + "-" + maxZ);
            this.putPaneTopLeftCornerAtWorldPos(bottomRightFake, new BlockPos(maxX, 0, maxZ));
            this.dragView.addChild((Pane)bottomRightFake);
            this.addCitizens(building.getColony());
            this.addCenterPos();
        } else {
            this.worldPosRoot = null;
        }
        this.registerButton("exit", () -> building.openGui(false));
        this.registerButton("inventory", this::inventoryClicked);
        new ColonyListMessage().sendToServer();
    }

    private void inventoryClicked() {
        new OpenInventoryMessage(this.building).sendToServer();
    }

    private void addMaps() {
        for (ITownHallView.MapEntry mapEntry : this.building.getMapDataList()) {
            MapItemSavedData mapData = mapEntry.mapData();
            int scale = 1 << mapData.scale;
            MinecraftMap mapImage = new MinecraftMap();
            this.putPaneTopLeftCornerAtWorldPos(mapImage, new BlockPos(mapData.centerX - 64 * scale, 0, mapData.centerZ - 64 * scale));
            mapImage.setID("map" + mapData.centerX + "-" + mapData.centerZ);
            mapImage.setMapData(mapEntry.mapId(), mapData);
            mapImage.setSize(256 * scale, 256 * scale);
            this.dragView.addChild((Pane)mapImage);
        }
    }

    public static void setColonies(List<ColonyListMessage.ColonyInfo> colonyInfo) {
        colonies = colonyInfo;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.hasMaps) {
            for (Map.Entry<ICitizenDataView, Pane> entry : this.citizens.entrySet()) {
                EntityCitizen citizen = (EntityCitizen)this.building.getColony().getWorld().getEntity(entry.getKey().getEntityId());
                if (citizen == null) continue;
                this.putPaneCenterAtWorldPos(entry.getValue(), citizen.blockPosition());
            }
            if (this.currentScale != this.dragView.getScale()) {
                this.currentScale = this.dragView.getScale();
                this.updateScale();
            }
        }
    }

    private void updateScale() {
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (IBuildingView iBuildingView : this.building.getColony().getBuildings()) {
            this.updateBuildingView(iBuildingView);
        }
        if (this.currentScale < 0.3) {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((ItemIcon)entry.getValue()).off();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((Pane)entry.getValue()).off();
            }
        } else {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((ItemIcon)entry.getValue()).on();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((Pane)entry.getValue()).on();
            }
            for (Map.Entry entry : this.coloniesImages.entrySet()) {
                ((View)entry.getValue()).off();
            }
        }
        ((Text)this.findPaneOfTypeByID("scale", Text.class)).setText(Component.literal((String)(this.scaleformet.format(1.0 / this.currentScale) + "x")));
    }

    private void updateColonyInfoImage(ColonyListMessage.ColonyInfo colonyInfo) {
        View colonyPane = this.coloniesImages.get(colonyInfo);
        if (colonyPane == null) {
            colonyPane = ColonySize.createViewForInfo(colonyInfo);
            colonyPane.setID(colonyInfo.getId() + colonyInfo.getOwner());
            this.dragView.addChild((Pane)colonyPane);
            this.coloniesImages.put(colonyInfo, colonyPane);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)colonyPane).append(Component.literal((String)("Owner:" + colonyInfo.getOwner())))).appendNL(Component.literal((String)("Coordinates: " + colonyInfo.getCenter().getX() + "X, " + colonyInfo.getCenter().getZ() + "Z")))).appendNL(Component.literal((String)("Citizens: " + colonyInfo.getCitizencount())))).build();
        }
        if (this.currentScale < 0.3) {
            this.putPaneCenterAtWorldPos((Pane)colonyPane, colonyInfo.getCenter());
            colonyPane.on();
        } else {
            colonyPane.off();
        }
    }

    private void addCenterPos() {
        Image citizenImage = new Image();
        citizenImage.setImage(new ResourceLocation("minecolonies", "textures/gui/red_wax_home.png"), false);
        citizenImage.setSize(16, 16);
        this.putPaneTopLeftCornerAtWorldPos((Pane)citizenImage, this.playerPos);
        this.dragView.setScaleRaw(0.8);
        this.dragView.setScrollX(this.dragView.calcInverseAbsoluteX((double)citizenImage.getX()) - (double)(this.dragView.getWidth() / 2));
        this.dragView.setScrollY(this.dragView.calcInverseAbsoluteY((double)citizenImage.getY()) - (double)(this.dragView.getHeight() / 2));
        this.putPaneCenterAtWorldPos((Pane)citizenImage, this.playerPos);
        this.dragView.addChild((Pane)citizenImage);
    }

    private void updateBuildingView(IBuildingView buildingView) {
        ItemIcon uiBuilding = this.buildings.get(buildingView);
        if (uiBuilding == null) {
            uiBuilding = new ItemIcon();
            uiBuilding.setID(buildingView.getID().toShortString());
            uiBuilding.setSize(11 + buildingView.getBuildingLevel(), 11 + buildingView.getBuildingLevel());
            ItemStack item = buildingView.getBuildingType().getBuildingBlock().asItem().getDefaultInstance();
            uiBuilding.setItem(item);
            this.dragView.addChild((Pane)uiBuilding);
            AbstractTextBuilder.TooltipBuilder tooltip = PaneBuilders.tooltipBuilder();
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)tooltip.hoverPane((Pane)uiBuilding).append((Component)BOScreen.getTooltipFromItem((Minecraft)this.mc, (ItemStack)item).get(0))).append(Component.literal((String)(" : " + buildingView.getBuildingLevel())))).appendNL(Component.literal((String)("Coordinates: " + buildingView.getID().getX() + "X, " + buildingView.getID().getZ() + "Z")))).appendNL(Component.literal((String)("Citizens: " + buildingView.getAllAssignedCitizens().size())));
            for (int id : buildingView.getAllAssignedCitizens()) {
                ICitizenDataView dataView = this.building.getColony().getCitizen(id);
                if (dataView == null) continue;
                tooltip.appendNL(Component.literal((String)dataView.getName()));
            }
            tooltip.build();
            uiBuilding.setVisible(true);
            this.buildings.put(buildingView, uiBuilding);
        }
        this.putPaneCenterAtWorldPos((Pane)uiBuilding, buildingView.getID());
    }

    private void addCitizens(IColonyView colony) {
        for (ICitizenDataView data : colony.getCitizens().values()) {
            EntityCitizen citizen = (EntityCitizen)colony.getWorld().getEntity(data.getEntityId());
            if (citizen == null) continue;
            View citizenView = new View();
            this.putPaneCenterAtWorldPos((Pane)citizenView, citizen.blockPosition());
            Image citizenImage = new Image();
            citizenImage.setImage(((ISimpleModelType)IModelTypeRegistry.getInstance().getModelType(citizen.getModelType())).getTextureIcon(citizen), false);
            citizenImage.setSize(4, 4);
            citizenView.addChild((Pane)citizenImage);
            this.dragView.addChild((Pane)citizenView);
            AbstractTextBuilder.TooltipBuilder builder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)citizenView).paragraphBreak()).append(citizen.getDisplayName());
            if (!data.getJob().isEmpty()) {
                citizenImage.setSize(8, 8);
                ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{Component.translatable((String)data.getJob())}));
            }
            ((AbstractTextBuilder.TooltipBuilder)builder.color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            citizenView.setSize(citizenImage.getWidth(), citizenImage.getHeight());
            if (data.hasVisibleInteractions()) {
                Image interactionImage = new Image();
                interactionImage.setImage(data.getInteractionIcon(), false);
                interactionImage.setSize(6, 6);
                citizenImage.setPosition(5, 0);
                citizenView.addChild((Pane)interactionImage);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            }
            if (this.citizens.containsKey(data)) {
                this.dragView.removeChild(this.citizens.get(data));
            }
            this.citizens.put(data, (Pane)citizenView);
        }
    }

    private void putPaneTopLeftCornerAtWorldPos(Pane pane, BlockPos worldPos) {
        this.applyWorldPosToPane(pane, worldPos, 0, 0);
    }

    private void putPaneCenterAtWorldPos(Pane pane, BlockPos worldPos) {
        this.applyWorldPosToPane(pane, worldPos, -pane.getWidth() / 2, -pane.getHeight() / 2);
    }

    private void applyWorldPosToPane(Pane pane, BlockPos worldPos, int offsetUiX, int offsetUiZ) {
        int x = worldPos.getX() - this.worldPosRoot.getX();
        int z = worldPos.getZ() - this.worldPosRoot.getZ();
        x *= 2;
        z *= 2;
        pane.setPosition(x += offsetUiX, z += offsetUiZ);
    }
}

