/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowBuildDecoration;
import com.minecolonies.core.network.messages.server.DecorationBuildRequestMessage;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WindowDecorationController
extends AbstractWindowSkeleton {
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowdecorationcontroller.xml";
    private final TileEntityDecorationController controller;
    private final Level world;

    public WindowDecorationController(BlockPos b) {
        super("minecolonies:gui/windowdecorationcontroller.xml");
        this.world = Minecraft.getInstance().level;
        this.controller = (TileEntityDecorationController)this.world.getBlockEntity(b);
        this.registerButton("build", this::buildClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("cancel", this::cancelClicked);
        ((Text)this.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)this.controller.getBlueprintPath()));
        IColonyView view = IColonyManager.getInstance().getClosestColonyView(this.world, this.controller.getBlockPos());
        Button buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        this.findPaneByID("repair").hide();
        this.findPaneByID("build").hide();
        if (view != null) {
            Optional<IWorkOrderView> wo = view.getWorkOrders().stream().filter(w -> w.getLocation().equals((Object)this.controller.getBlockPos())).findFirst();
            int level = Utils.getBlueprintLevel(this.controller.getBlueprintPath());
            if (wo.isPresent()) {
                this.findPaneByID("build").show();
                buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild", (Object[])new Object[0]));
                if (wo.get().getWorkOrderType() == WorkOrderType.REPAIR) {
                    buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair", (Object[])new Object[0]));
                }
            } else {
                buttonBuild.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.upgrade", (Object[])new Object[0]));
                try {
                    String cleanedPackName = this.controller.getPackName().replace(Minecraft.getInstance().player.getUUID().toString(), "");
                    ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)cleanedPackName, (Path)StructurePacks.getStructurePack((String)cleanedPackName).getPath().resolve(this.controller.getBlueprintPath()), (HolderLookup.Provider)this.mc.level.registryAccess()), blueprint -> {
                        BlockState blockState;
                        if (blueprint != null && (blockState = blueprint.getBlockState(blueprint.getPrimaryBlockOffset())).getBlock() == ModBlocks.blockDecorationPlaceholder) {
                            this.findPaneByID("repair").show();
                        }
                    }));
                    if (level != -1) {
                        String path = this.controller.getBlueprintPath().replace(level + ".blueprint", level + 1 + ".blueprint");
                        ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)cleanedPackName, (Path)StructurePacks.getStructurePack((String)cleanedPackName).getPath().resolve(path), (HolderLookup.Provider)this.mc.level.registryAccess()), blueprint -> {
                            BlockState blockState;
                            if (blueprint != null && (blockState = blueprint.getBlockState(blueprint.getPrimaryBlockOffset())).getBlock() == ModBlocks.blockDecorationPlaceholder) {
                                this.findPaneByID("build").show();
                            }
                        }));
                    }
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to retrieve blueprint");
                }
            }
        }
    }

    private void cancelClicked() {
        this.close();
    }

    private void buildClicked() {
        int level = Utils.getBlueprintLevel(this.controller.getBlueprintPath());
        String path = this.controller.getBlueprintPath().replace(level + ".blueprint", level + 1 + ".blueprint");
        this.close();
        new WindowBuildDecoration(this.controller.getBlockPos(), this.controller.getPackName(), path, this.controller.getRotationMirror(), builder -> new DecorationBuildRequestMessage(WorkOrderType.BUILD, this.controller.getBlockPos(), this.controller.getPackName(), path, (ResourceKey<Level>)Minecraft.getInstance().level.dimension(), this.controller.getRotationMirror(), (BlockPos)builder)).open();
    }

    private void repairClicked() {
        this.close();
        new WindowBuildDecoration(this.controller.getBlockPos(), this.controller.getPackName(), this.controller.getBlueprintPath(), this.controller.getRotationMirror(), builder -> new DecorationBuildRequestMessage(WorkOrderType.REPAIR, this.controller.getBlockPos(), this.controller.getPackName(), this.controller.getBlueprintPath(), (ResourceKey<Level>)Minecraft.getInstance().level.dimension(), this.controller.getRotationMirror(), (BlockPos)builder)).open();
    }
}

