/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesHorizontal;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.core.client.gui.WindowPlantationField;
import com.minecolonies.core.colony.fields.PlantationField;
import com.minecolonies.core.tileentities.TileEntityPlantationField;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockPlantationField
extends AbstractBlockMinecoloniesHorizontal<BlockPlantationField>
implements IBuilderUndestroyable,
IAnchorBlock,
IBuildingBrowsableBlock,
EntityBlock {
    public static final MapCodec<BlockPlantationField> CODEC = BlockPlantationField.simpleCodec(BlockPlantationField::new);
    public static final BooleanProperty MIRROR = BooleanProperty.create((String)"mirror");
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "blockhutplantationfield";
    private static final float RESISTANCE = 1.0f;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);

    public BlockPlantationField() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(5.0f, 1.0f));
    }

    public BlockPlantationField(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)MIRROR, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BlockPlantationField> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityPlantationField(blockPos, blockState);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)MIRROR, (Comparable)Boolean.valueOf(mirrorIn != Mirror.NONE));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.isClientSide) {
            if (hand == InteractionHand.OFF_HAND) {
                return ItemInteractionResult.FAIL;
            }
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof TileEntityPlantationField) {
                TileEntityPlantationField plantationField = (TileEntityPlantationField)tileEntity;
                new WindowPlantationField(plantationField).open();
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (SHAPES.containsKey(dir)) {
            return SHAPES.get(dir);
        }
        VoxelShape shape = Shapes.box((double)(0.0 + (dir.getStepX() > 0 ? 0.5 : 0.0)), (double)0.0, (double)(0.0 + (dir.getStepZ() > 0 ? 0.5 : 0.0)), (double)(1.0 - (dir.getStepX() < 0 ? 0.5 : 0.0)), (double)0.625, (double)(1.0 - (dir.getStepZ() < 0 ? 0.5 : 0.0)));
        SHAPES.put(dir, shape);
        return shape;
    }

    public void wasExploded(Level worldIn, BlockPos pos, Explosion explosionIn) {
        this.notifyColonyAboutDestruction(worldIn, pos);
        super.wasExploded(worldIn, pos, explosionIn);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof TileEntityPlantationField) {
            TileEntityPlantationField tileEntityPlantationField = (TileEntityPlantationField)tileEntity;
            IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
            if (colony != null) {
                for (FieldRegistries.FieldEntry plantationFieldType : tileEntityPlantationField.getPlantationFieldTypes()) {
                    PlantationField plantationField = PlantationField.create(plantationFieldType, pos);
                    List<BlockPos> workingPositions = tileEntityPlantationField.getWorkingPositions(plantationField.getModule().getWorkTag());
                    List<BlockPos> validPositions = plantationField.getModule().getValidWorkingPositions(worldIn, workingPositions);
                    if (validPositions.isEmpty()) continue;
                    plantationField.setWorkingPositions(validPositions);
                    colony.getBuildingManager().addField(plantationField);
                    colony.getBuildingManager().addLeisureSite(pos);
                }
            }
        }
    }

    public BlockState playerWillDestroy(Level worldIn, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        this.notifyColonyAboutDestruction(worldIn, pos);
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MIRROR});
    }

    private void notifyColonyAboutDestruction(Level worldIn, BlockPos pos) {
        BlockEntity blockEntity;
        IColony colony;
        if (!worldIn.isClientSide() && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null && (blockEntity = worldIn.getBlockEntity(pos)) instanceof TileEntityPlantationField) {
            TileEntityPlantationField plantationField = (TileEntityPlantationField)blockEntity;
            for (FieldRegistries.FieldEntry plantationFieldType : plantationField.getPlantationFieldTypes()) {
                colony.getBuildingManager().removeField(field -> field.getFieldType().equals(plantationFieldType) && field.getPosition().equals((Object)pos));
                colony.getBuildingManager().removeLeisureSite(pos);
            }
        }
    }
}

