/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class FireworkUtils {
    private FireworkUtils() {
    }

    public static void spawnFireworksAtAABBCorners(Tuple<BlockPos, BlockPos> realaabb, Level world, int explosionLevel) {
        FireworkUtils.fireRocket(world, new BlockPos(((BlockPos)realaabb.getB()).getX(), ((BlockPos)realaabb.getB()).getY(), ((BlockPos)realaabb.getB()).getZ()), explosionLevel);
        FireworkUtils.fireRocket(world, new BlockPos(((BlockPos)realaabb.getB()).getX(), ((BlockPos)realaabb.getB()).getY(), ((BlockPos)realaabb.getA()).getZ()), explosionLevel);
        FireworkUtils.fireRocket(world, new BlockPos(((BlockPos)realaabb.getA()).getX(), ((BlockPos)realaabb.getB()).getY(), ((BlockPos)realaabb.getB()).getZ()), explosionLevel);
        FireworkUtils.fireRocket(world, new BlockPos(((BlockPos)realaabb.getA()).getX(), ((BlockPos)realaabb.getB()).getY(), ((BlockPos)realaabb.getA()).getZ()), explosionLevel);
    }

    private static void fireRocket(Level world, BlockPos position, int explosionLevel) {
        if (world.canSeeSky(position)) {
            FireworkRocketEntity firework = new FireworkRocketEntity(world, (double)position.getX(), (double)position.getY(), (double)position.getZ(), FireworkUtils.genFireworkItemStack(explosionLevel));
            world.addFreshEntity((Entity)firework);
        }
    }

    private static ItemStack genFireworkItemStack(int explosionAmount) {
        Random rand = new Random();
        ItemStack fireworkItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        ArrayList<FireworkExplosion> list = new ArrayList<FireworkExplosion>();
        int[] dyeColors = Arrays.stream(DyeColor.values()).mapToInt(DyeColor::getFireworkColor).toArray();
        for (int i = 0; i < explosionAmount; ++i) {
            CompoundTag explosionTag = new CompoundTag();
            explosionTag.putInt("Type", rand.nextInt(5));
            int numberOfColours = rand.nextInt(3) + 1;
            IntArrayList colors = new IntArrayList();
            for (int ia = 0; ia < numberOfColours; ++ia) {
                colors.add(dyeColors[rand.nextInt(15)]);
            }
            explosionTag.putIntArray("Colors", (List)colors);
            list.add(new FireworkExplosion(FireworkExplosion.Shape.values()[rand.nextInt(FireworkExplosion.Shape.values().length)], (IntList)colors, (IntList)colors, rand.nextInt(2) == 0, rand.nextInt(2) == 0));
        }
        fireworkItem.set(DataComponents.FIREWORKS, (Object)new Fireworks(explosionAmount, list));
        return fireworkItem;
    }
}

