/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.util.ChunkCapData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public final class ColonyUtils {
    private ColonyUtils() {
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(BlockPos pos, Level world, Blueprint blueprint, RotationMirror rotMir) {
        if (blueprint == null) {
            return new Tuple((Object)pos, (Object)pos);
        }
        blueprint.setRotationMirror(rotMir, world);
        BlockPos zeroPos = pos.subtract((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.getX(), zeroPos.getY(), zeroPos.getZ());
        BlockPos pos2 = new BlockPos(zeroPos.getX() + blueprint.getSizeX() - 1, zeroPos.getY() + blueprint.getSizeY() - 1, zeroPos.getZ() + blueprint.getSizeZ() - 1);
        return new Tuple((Object)pos1, (Object)pos2);
    }

    public static int getOwningColony(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? 0 : cap.getOwningColony();
    }

    public static Map<Integer, Set<BlockPos>> getAllClaimingBuildings(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new HashMap() : cap.getAllClaimingBuildings();
    }

    public static List<Integer> getStaticClaims(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new ArrayList() : cap.getStaticClaimColonies();
    }

    @Nullable
    public static ChunkCapData getChunkCapData(ChunkAccess chunk) {
        IChunkClaimData cap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)chunk.getLevel().dimension(), chunk.getPos());
        return cap == null ? new ChunkCapData(chunk.getPos().x, chunk.getPos().z) : new ChunkCapData(chunk.getPos().x, chunk.getPos().z, cap.getOwningColony(), cap.getStaticClaimColonies(), cap.getAllClaimingBuildings());
    }
}

