/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.quests.registries;

import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class QuestRegistries {
    public static ResourceLocation ITEM_REWARD_ID = new ResourceLocation("minecolonies", "item");
    public static ResourceLocation SKILL_REWARD_ID = new ResourceLocation("minecolonies", "skill");
    public static ResourceLocation RESEARCH_REWARD_ID = new ResourceLocation("minecolonies", "research");
    public static ResourceLocation RAID_REWARD_ID = new ResourceLocation("minecolonies", "raid");
    public static ResourceLocation RELATIONSHIP_REWARD_ID = new ResourceLocation("minecolonies", "relationship");
    public static ResourceLocation HAPPINESS_REWARD_ID = new ResourceLocation("minecolonies", "happiness");
    public static ResourceLocation UNLOCK_QUEST_REWARD_ID = new ResourceLocation("minecolonies", "unlockquest");
    public static ResourceLocation QUEST_REPUTATION_REWARD_ID = new ResourceLocation("minecolonies", "questreputation");
    public static ResourceLocation DIALOGUE_OBJECTIVE_ID = new ResourceLocation("minecolonies", "dialogue");
    public static ResourceLocation BREAKBLOCK_OBJECTIVE_ID = new ResourceLocation("minecolonies", "breakblock");
    public static ResourceLocation DELIVERY_OBJECTIVE_ID = new ResourceLocation("minecolonies", "delivery");
    public static ResourceLocation KILLENTITY_OBJECTIVE_ID = new ResourceLocation("minecolonies", "killentity");
    public static ResourceLocation PLACEBLOCK_OBJECTIVE_ID = new ResourceLocation("minecolonies", "placeblock");
    public static ResourceLocation BUILD_BUILDING_OBJECTIVE_ID = new ResourceLocation("minecolonies", "buildbuilding");
    public static ResourceLocation RESEARCH_OBJECTIVE_ID = new ResourceLocation("minecolonies", "research");
    public static ResourceLocation STATE_TRIGGER_ID = new ResourceLocation("minecolonies", "state");
    public static ResourceLocation RANDOM_TRIGGER_ID = new ResourceLocation("minecolonies", "random");
    public static ResourceLocation CITIZEN_TRIGGER_ID = new ResourceLocation("minecolonies", "citizen");
    public static ResourceLocation UNLOCK_TRIGGER_ID = new ResourceLocation("minecolonies", "unlock");
    public static ResourceLocation QUEST_REPUTATION_TRIGGER_ID = new ResourceLocation("minecolonies", "questreputation");
    public static ResourceLocation WORLD_DIFFICULTY_TRIGGER_ID = new ResourceLocation("minecolonies", "difficulty");
    public static ResourceLocation DIALOGUE_ANSWER_ID = new ResourceLocation("minecolonies", "dialogue");
    public static ResourceLocation RETURN_ANSWER_ID = new ResourceLocation("minecolonies", "return");
    public static ResourceLocation CANCEL_ANSWER_ID = new ResourceLocation("minecolonies", "cancel");
    public static ResourceLocation GOTO_ANSWER_ID = new ResourceLocation("minecolonies", "advanceobjective");
    public static DeferredHolder<RewardEntry, RewardEntry> itemReward;
    public static DeferredHolder<RewardEntry, RewardEntry> skillReward;
    public static DeferredHolder<RewardEntry, RewardEntry> researchReward;
    public static DeferredHolder<RewardEntry, RewardEntry> raidReward;
    public static DeferredHolder<RewardEntry, RewardEntry> relationshipReward;
    public static DeferredHolder<RewardEntry, RewardEntry> happinessReward;
    public static DeferredHolder<RewardEntry, RewardEntry> unlockQuestReward;
    public static DeferredHolder<RewardEntry, RewardEntry> questReputationReward;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> dialogueObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> breakBlockObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> deliveryObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> killEntityObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> placeBlockObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> buildBuildingObjective;
    public static DeferredHolder<ObjectiveEntry, ObjectiveEntry> researchObjective;
    public static DeferredHolder<TriggerEntry, TriggerEntry> stateTrigger;
    public static DeferredHolder<TriggerEntry, TriggerEntry> randomTrigger;
    public static DeferredHolder<TriggerEntry, TriggerEntry> citizenTrigger;
    public static DeferredHolder<TriggerEntry, TriggerEntry> unlockTrigger;
    public static DeferredHolder<TriggerEntry, TriggerEntry> questReputationTrigger;
    public static DeferredHolder<TriggerEntry, TriggerEntry> worldDifficultyTrigger;
    public static DeferredHolder<DialogueAnswerEntry, DialogueAnswerEntry> dialogueAnswerResult;
    public static DeferredHolder<DialogueAnswerEntry, DialogueAnswerEntry> returnAnswerResult;
    public static DeferredHolder<DialogueAnswerEntry, DialogueAnswerEntry> cancelAnswerResult;
    public static DeferredHolder<DialogueAnswerEntry, DialogueAnswerEntry> gotoAnswerResult;

    static Registry<RewardEntry> getQuestRewardsRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestRewardRegistry();
    }

    static Registry<ObjectiveEntry> getQuestObjectiveRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestObjectiveRegistry();
    }

    static Registry<TriggerEntry> getQuestTriggerRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestTriggerRegistry();
    }

    static Registry<DialogueAnswerEntry> getDialogueAnswerResultRegistry() {
        return IMinecoloniesAPI.getInstance().getQuestDialogueAnswerRegistry();
    }

    public static class DialogueAnswerEntry {
        private final Function<JsonObject, IQuestDialogueAnswer> producer;

        public DialogueAnswerEntry(Function<JsonObject, IQuestDialogueAnswer> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestDialogueAnswer produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }

    public static class TriggerEntry {
        private final Function<JsonObject, IQuestTriggerTemplate> producer;

        public TriggerEntry(Function<JsonObject, IQuestTriggerTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestTriggerTemplate produce(JsonObject jsonObject) {
            return this.producer.apply(jsonObject);
        }
    }

    public static class ObjectiveEntry {
        private final BiFunction<HolderLookup.Provider, JsonObject, IQuestObjectiveTemplate> producer;

        public ObjectiveEntry(BiFunction<HolderLookup.Provider, JsonObject, IQuestObjectiveTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public IQuestObjectiveTemplate produce(@NotNull HolderLookup.Provider provider, JsonObject jsonObject) {
            return this.producer.apply(provider, jsonObject);
        }
    }

    public static class RewardEntry {
        private Function<JsonObject, IQuestRewardTemplate> producer = null;
        private BiFunction<HolderLookup.Provider, JsonObject, IQuestRewardTemplate> providerProducer = null;

        public RewardEntry(Function<JsonObject, IQuestRewardTemplate> productionFunction) {
            this.producer = productionFunction;
        }

        public RewardEntry(BiFunction<HolderLookup.Provider, JsonObject, IQuestRewardTemplate> productionFunction) {
            this.providerProducer = productionFunction;
        }

        public IQuestRewardTemplate produce(@NotNull HolderLookup.Provider provider, JsonObject jsonObject) {
            if (this.producer != null) {
                return this.producer.apply(jsonObject);
            }
            return this.providerProducer.apply(provider, jsonObject);
        }
    }
}

