/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.minecolonies.api.loot.EntityInBiomeTag;
import com.minecolonies.api.loot.GenerateSupplyLoot;
import com.minecolonies.api.loot.ResearchUnlocked;
import java.util.List;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class ModLootConditions {
    public static final DeferredRegister<LootItemConditionType> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"minecolonies");
    public static final ResourceLocation ENTITY_IN_BIOME_TAG_ID = new ResourceLocation("minecolonies", "entity_in_biome_tag");
    public static final ResourceLocation RESEARCH_UNLOCKED_ID = new ResourceLocation("minecolonies", "research_unlocked");
    public static final ResourceLocation GENERATE_SUPPLY_LOOT_ID = new ResourceLocation("minecolonies", "generate_supply_loot");
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> entityInBiomeTag;
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> researchUnlocked;
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> generateSupplyLoot;
    public static final LootItemCondition.Builder HAS_SHEARS;
    public static final LootItemCondition.Builder HAS_NETHERITE_HOE;
    public static final LootItemCondition.Builder HAS_DIAMOND_HOE;
    public static final LootItemCondition.Builder HAS_IRON_HOE;
    public static final LootItemCondition.Builder HAS_GOLDEN_HOE;
    public static final LootItemCondition.Builder HAS_HOE;

    public static LootItemCondition.Builder hasShears() {
        return HAS_SHEARS;
    }

    public static LootItemCondition.Builder hasHoe() {
        return HAS_HOE;
    }

    public static LootItemCondition.Builder hasSilkTouch(@NotNull HolderLookup.RegistryLookup<Enchantment> enchantments) {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    public static LootItemCondition.Builder hasShearsOrSilkTouch(@NotNull HolderLookup.RegistryLookup<Enchantment> enchantments) {
        return ModLootConditions.hasShears().or(ModLootConditions.hasSilkTouch(enchantments));
    }

    public static LootItemCondition.Builder doesNotHaveShearsOrSilkTouch(@NotNull HolderLookup.RegistryLookup<Enchantment> enchantments) {
        return ModLootConditions.hasShearsOrSilkTouch(enchantments).invert();
    }

    public static void init() {
    }

    private ModLootConditions() {
        throw new IllegalStateException("Tried to initialize: ModLootConditions but this is a Utility class.");
    }

    static {
        HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
        HAS_NETHERITE_HOE = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.NETHERITE_HOE}));
        HAS_DIAMOND_HOE = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.DIAMOND_HOE}));
        HAS_IRON_HOE = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.IRON_HOE}));
        HAS_GOLDEN_HOE = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.GOLDEN_HOE}));
        HAS_HOE = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.HOES));
        entityInBiomeTag = DEFERRED_REGISTER.register(ENTITY_IN_BIOME_TAG_ID.getPath(), () -> new LootItemConditionType(EntityInBiomeTag.CODEC));
        researchUnlocked = DEFERRED_REGISTER.register(RESEARCH_UNLOCKED_ID.getPath(), () -> new LootItemConditionType(ResearchUnlocked.CODEC));
        generateSupplyLoot = DEFERRED_REGISTER.register(GENERATE_SUPPLY_LOOT_ID.getPath(), () -> new LootItemConditionType(GenerateSupplyLoot.CODEC));
    }
}

