/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Food
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Food.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_EXCLUSION = "Exclusion";
    private static final String NBT_MIN_NUTRITION = "MinNutrition";
    private final int count;
    private final int minNutrition;
    private final List<ItemStorage> exclusionList = new ArrayList<ItemStorage>();
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Food(int count, int minNutrition) {
        this.count = count;
        this.minNutrition = minNutrition;
    }

    public Food(int count, @NotNull ItemStack result, int minNutrition) {
        this.count = count;
        this.result = result;
        this.minNutrition = minNutrition;
    }

    public Food(int count, @NotNull ItemStack result, List<ItemStorage> exclusionList, int minNutrition) {
        this.count = count;
        this.result = result;
        this.exclusionList.addAll(exclusionList);
        this.minNutrition = minNutrition;
    }

    public Food(int count, List<ItemStorage> exclusionList, int minNutrition) {
        this(count, ItemStackUtils.EMPTY, exclusionList, minNutrition);
    }

    public static CompoundTag serialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, Food food) {
        CompoundTag compound = new CompoundTag();
        compound.putInt(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result)) {
            compound.put(NBT_RESULT, food.result.saveOptional(provider));
        }
        if (!food.exclusionList.isEmpty()) {
            @NotNull ListTag items = new ListTag();
            for (ItemStorage item : food.exclusionList) {
                items.add((Object)item.getItemStack().saveOptional(provider));
            }
            compound.put(NBT_EXCLUSION, (Tag)items);
        }
        compound.putInt(NBT_MIN_NUTRITION, food.minNutrition);
        return compound;
    }

    public static Food deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        int count = compound.getInt(NBT_COUNT);
        ItemStack result = compound.contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.getCompound(NBT_RESULT), provider) : ItemStackUtils.EMPTY;
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        if (compound.contains(NBT_EXCLUSION)) {
            ListTag filterableItems = compound.getList(NBT_EXCLUSION, 10);
            for (int i = 0; i < filterableItems.size(); ++i) {
                items.add(new ItemStorage(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)filterableItems.getCompound(i))));
            }
        }
        int minNutrition = compound.getInt(NBT_MIN_NUTRITION);
        return new Food(count, result, items, minNutrition);
    }

    public static void serialize(IFactoryController controller, RegistryFriendlyByteBuf buffer, Food input) {
        buffer.writeInt(input.count);
        buffer.writeBoolean(!ItemStackUtils.isEmpty(input.result));
        if (!ItemStackUtils.isEmpty(input.result)) {
            Utils.serializeCodecMess(buffer, input.result);
        }
        buffer.writeInt(input.exclusionList.size());
        for (ItemStorage item : input.exclusionList) {
            Utils.serializeCodecMess(buffer, item.getItemStack());
        }
        buffer.writeInt(input.minNutrition);
    }

    public static Food deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? Utils.deserializeCodecMess(buffer) : ItemStack.EMPTY;
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        int itemsCount = buffer.readInt();
        for (int i = 0; i < itemsCount; ++i) {
            items.add(new ItemStorage(Utils.deserializeCodecMess(buffer)));
        }
        int minNutrition = buffer.readInt();
        if (!items.isEmpty()) {
            return new Food(count, result, items, minNutrition);
        }
        return new Food(count, result, minNutrition);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return !(!ItemStackUtils.ISFOOD.test(stack) || this.exclusionList.contains(new ItemStorage(stack)) || ItemStackUtils.ISCOOKABLE.test(stack) && this.exclusionList.contains(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack))) || !ItemStackUtils.ISCOOKABLE.test(stack) && stack.getItem().getFoodProperties(stack, null).nutrition() < this.minNutrition);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Food(newCount, this.exclusionList, this.minNutrition);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStorage> getExclusionList() {
        return this.exclusionList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Food)) {
            return false;
        }
        Food food = (Food)o;
        if (this.getCount() != food.getCount()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), food.getResult());
    }

    public int hashCode() {
        int result1 = this.getCount();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }

    @Override
    public boolean canBeResolvedByBuilding() {
        return false;
    }
}

