/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.network;

import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequesterSyncPacket(boolean clearData, long requesterId, CompoundTag data) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<RequesterSyncPacket> TYPE = new CustomPacketPayload.Type(Utils.getRL("requester_sync"));
    static final StreamCodec<ByteBuf, RequesterSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, RequesterSyncPacket::clearData, (StreamCodec)ByteBufCodecs.VAR_LONG, RequesterSyncPacket::requesterId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, RequesterSyncPacket::data, RequesterSyncPacket::new);

    public static RequesterSyncPacket createClearData() {
        return new RequesterSyncPacket(true, -1L, new CompoundTag());
    }

    public static RequesterSyncPacket createInventory(long requesterId, CompoundTag data) {
        return new RequesterSyncPacket(false, requesterId, data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequesterSyncPacket payload, IPayloadContext context) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractRequesterScreen) {
            AbstractRequesterScreen screen2 = (AbstractRequesterScreen)screen;
            screen2.updateFromMenu(payload.clearData, payload.requesterId, payload.data);
        }
    }
}

