/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.maxhealthfix.common.mixin;

import net.darkhax.maxhealthfix.common.impl.IHealthFixable;
import net.darkhax.maxhealthfix.common.impl.MaxHealthFixMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=9001)
public abstract class MixinLivingEntity
implements IHealthFixable {
    @Unique
    @Nullable
    private Float maxhealthfix$restorePoint = null;

    @Override
    public void maxhealthfix$setRestorePoint(Float restorePoint) {
        this.maxhealthfix$restorePoint = restorePoint;
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void maxhealthfix$readAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        float savedHealth;
        if (tag.contains("Health", 99) && (savedHealth = tag.getFloat("Health")) > this.getMaxHealth() && savedHealth > 0.0f) {
            this.maxhealthfix$setRestorePoint(Float.valueOf(savedHealth));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void maxhealthfix$tick(CallbackInfo callback) {
        if (this.maxhealthfix$restorePoint != null) {
            if (MaxHealthFixMod.getConfig().mod_enabled && this.maxhealthfix$restorePoint.floatValue() > 0.0f && this.maxhealthfix$restorePoint.floatValue() > this.getHealth()) {
                this.setHealth(this.maxhealthfix$restorePoint.floatValue());
            }
            this.maxhealthfix$setRestorePoint(null);
        }
    }

    @Shadow
    public abstract float getMaxHealth();

    @Shadow
    public abstract float getHealth();

    @Shadow
    public abstract void setHealth(float var1);
}

