/*
 * Decompiled with CFR 0.152.
 */
package com.vendoau.maptooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;

public class MapTooltipComponent
implements ClientTooltipComponent,
TooltipComponent {
    private final ResourceLocation bg = ResourceLocation.parse((String)"textures/map/map_background.png");
    private final MapId id;

    public MapTooltipComponent(ItemStack map) {
        this.id = (MapId)map.get(DataComponents.MAP_ID);
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics graphics) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        graphics.blit(this.bg, x, y, 0.0f, 0.0f, 64, 64, 64, 64);
        poseStack.popPose();
        MapItemSavedData data = Minecraft.getInstance().level.getMapData(this.id);
        if (data == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate((float)x + 3.2f, (float)y + 3.2f, 401.0f);
        poseStack.scale(0.45f, 0.45f, 1.0f);
        Minecraft.getInstance().gameRenderer.getMapRenderer().render(poseStack, (MultiBufferSource)graphics.bufferSource(), this.id, data, true, 0xF000F0);
        poseStack.popPose();
    }

    public int getHeight() {
        return 66;
    }

    public int getWidth(@NotNull Font font) {
        return 66;
    }
}

