/*
 * Decompiled with CFR 0.152.
 */
package com.vendoau.maptooltip;

import com.mojang.datafixers.util.Either;
import com.vendoau.maptooltip.MapCache;
import com.vendoau.maptooltip.MapTooltipComponent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@Mod(value="maptooltip")
@EventBusSubscriber(modid="maptooltip")
public class MapTooltip {
    private static boolean loadNextTick;

    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack item = event.getItemStack();
        if (!item.is(Items.FILLED_MAP)) {
            return;
        }
        List elements = event.getTooltipElements();
        elements.add(1, Either.right((Object)new MapTooltipComponent(item)));
    }

    @SubscribeEvent
    public static void joinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        loadNextTick = true;
    }

    @SubscribeEvent
    public static void tick(ClientTickEvent.Post event) {
        if (loadNextTick) {
            Minecraft mc = Minecraft.getInstance();
            MapCache.load(mc.getCurrentServer(), mc.level);
            loadNextTick = false;
        }
    }

    @SubscribeEvent
    public static void leaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        Minecraft mc = Minecraft.getInstance();
        MapCache.save(mc.getCurrentServer(), mc.level);
    }
}

