/*
 * Decompiled with CFR 0.152.
 */
package com.vendoau.maptooltip;

import com.vendoau.maptooltip.Constants;
import com.vendoau.maptooltip.mixin.ClientLevelAccessor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MapCache {
    private static final List<MapId> cachedIds = new ArrayList<MapId>();

    public static void load(ServerData server, ClientLevel level) {
        if (server == null) {
            return;
        }
        Constants.LOGGER.info("Loading map data for {}", (Object)server.ip);
        Path serverDir = MapCache.getServerDir(server);
        if (!Files.exists(serverDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(serverDir);){
            cachedIds.clear();
            paths.forEach(path -> MapCache.load(path, level));
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to load map data");
            Constants.LOGGER.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private static void load(Path path, ClientLevel level) {
        MapId mapId = MapCache.getMapIdFromPath(path);
        try {
            CompoundTag tag = NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap()).getCompound("data");
            MapItemSavedData data = MapItemSavedData.load((CompoundTag)tag, (HolderLookup.Provider)level.registryAccess());
            Map<MapId, MapItemSavedData> mapIds = ((ClientLevelAccessor)level).getDataForMaps();
            mapIds.put(mapId, data);
            cachedIds.add(mapId);
            Constants.LOGGER.info("Loaded map data ({})", (Object)mapId.id());
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to load map data ({})", (Object)mapId.id());
            Constants.LOGGER.error("Data is probably corrupted, deleting...");
            MapCache.delete(path);
        }
    }

    private static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
            Constants.LOGGER.info("File successfully deleted");
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to delete file");
        }
    }

    private static MapId getMapIdFromPath(Path path) {
        String fileName = path.getFileName().toString();
        int id = Integer.parseInt(fileName.substring(4, fileName.length() - 4));
        return new MapId(id);
    }

    private static String getServerAddress(ServerData server) {
        String[] split = server.ip.split(":");
        String ip = split[0];
        if (ip.equals("127.0.0.1")) {
            ip = "localhost";
        }
        if (split.length == 1) {
            return ip;
        }
        String port = split[1];
        if (port.equals("25565")) {
            return ip;
        }
        return ip + "_" + port;
    }

    private static Path getServerDir(ServerData server) {
        String address = MapCache.getServerAddress(server);
        return Constants.CONFIG_DIR.resolve("cache").resolve(address);
    }

    public static void save(@Nullable ServerData server, ClientLevel level) {
        if (server == null) {
            return;
        }
        Constants.LOGGER.info("Saving map data for {}", (Object)server.ip);
        ((ClientLevelAccessor)level).getDataForMaps().forEach((mapId, data) -> {
            if (cachedIds.contains(mapId)) {
                return;
            }
            try {
                Path serverDir = MapCache.getServerDir(server);
                Files.createDirectories(serverDir, new FileAttribute[0]);
                RegistryAccess provider = level.registryAccess();
                data.save(serverDir.resolve(mapId.key() + ".dat").toFile(), (HolderLookup.Provider)provider);
                Constants.LOGGER.info("Saved map data ({})", (Object)mapId.id());
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to save map data ({})", (Object)mapId.id());
                Constants.LOGGER.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        });
    }

    public static void update(MapId mapId) {
        cachedIds.remove(mapId);
    }
}

