/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.setup;

import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.client.entity.LootrChestCartRenderer;
import noobanidus.mods.lootr.common.client.item.LootrChestItemRenderer;
import noobanidus.mods.lootr.common.client.item.LootrShulkerItemRenderer;
import noobanidus.mods.lootr.neoforge.client.block.BarrelModel;
import noobanidus.mods.lootr.neoforge.client.block.LootrChestBlockRenderer;
import noobanidus.mods.lootr.neoforge.client.block.LootrShulkerBlockRenderer;

@EventBusSubscriber(modid="lootr", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @SubscribeEvent
    public static void modelRegister(ModelEvent.RegisterGeometryLoaders event) {
        event.register(LootrAPI.rl("barrel"), (IGeometryLoader)BarrelModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(LootrRegistry.getChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getTrappedChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getChestBlockEntity(), LootrChestBlockRenderer::new);
        event.registerBlockEntityRenderer(LootrRegistry.getShulkerBlockEntity(), LootrShulkerBlockRenderer::new);
        event.registerEntityRenderer(LootrRegistry.getMinecart(), e -> new LootrChestCartRenderer(e, ModelLayers.CHEST_MINECART));
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return LootrChestItemRenderer.getInstance();
            }
        }, new Item[]{LootrRegistry.getChestItem()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return LootrShulkerItemRenderer.getInstance();
            }
        }, new Item[]{LootrRegistry.getShulkerItem()});
    }
}

