/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrEntityConverter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import org.jetbrains.annotations.Nullable;

public class LootrServiceRegistry {
    private static LootrServiceRegistry INSTANCE;
    private final Map<BlockEntityType<?>, Function<?, ?>> blockEntityConverterMap = new Object2ObjectOpenHashMap();
    private final Map<EntityType<?>, Function<?, ?>> entityConverterMap = new Object2ObjectOpenHashMap();

    public LootrServiceRegistry() {
        ServiceLoader<ILootrBlockEntityConverter> loader = ServiceLoader.load(ILootrBlockEntityConverter.class);
        for (ILootrBlockEntityConverter converter : loader) {
            this.blockEntityConverterMap.put(converter.getBlockEntityType(), converter);
        }
        ServiceLoader<ILootrEntityConverter> loader2 = ServiceLoader.load(ILootrEntityConverter.class);
        for (ILootrEntityConverter converter2 : loader2) {
            this.entityConverterMap.put(converter2.getEntityType(), converter2);
        }
    }

    public static LootrServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LootrServiceRegistry();
        }
        return INSTANCE;
    }

    @Nullable
    private static <T> Function<T, ILootrBlockEntity> getBlockEntity(BlockEntityType<?> clazz) {
        return LootrServiceRegistry.getInstance().blockEntityConverterMap.get(clazz);
    }

    @Nullable
    private static <T> Function<T, ILootrCart> getEntity(EntityType<?> clazz) {
        return LootrServiceRegistry.getInstance().entityConverterMap.get(clazz);
    }

    @Nullable
    public static <T extends BlockEntity> ILootrBlockEntity convertBlockEntity(T blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        Function<T, ILootrBlockEntity> converter = LootrServiceRegistry.getBlockEntity(blockEntity.getType());
        if (converter == null) {
            return null;
        }
        return converter.apply(blockEntity);
    }

    @Nullable
    public static <T extends Entity> ILootrCart convertEntity(T entity) {
        if (entity == null) {
            return null;
        }
        Function<T, ILootrCart> converter = LootrServiceRegistry.getEntity(entity.getType());
        if (converter == null) {
            return null;
        }
        return converter.apply(entity);
    }
}

