/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import io.github.lightman314.lightmanscurrency.util.ItemStackHelper;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryUtil {
    public static SimpleContainer buildInventory(List<ItemStack> list) {
        SimpleContainer inventory = new SimpleContainer(list.size());
        for (int i = 0; i < list.size(); ++i) {
            inventory.setItem(i, list.get(i).copy());
        }
        return inventory;
    }

    public static Container buildInventory(ItemStack stack) {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.setItem(0, stack);
        return inventory;
    }

    public static Container copyInventory(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.getContainerSize());
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            copy.setItem(i, inventory.getItem(i).copy());
        }
        return copy;
    }

    public static NonNullList<ItemStack> buildList(Container inventory) {
        NonNullList list = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            list.set(i, (Object)inventory.getItem(i).copy());
        }
        return list;
    }

    public static List<ItemStack> copyList(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            result.add(stack.copy());
        }
        return result;
    }

    public static int GetItemCount(Container inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != item) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static int GetItemCount(Container inventory, ItemStack item) {
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static int GetItemCount(IItemHandler inventory, ItemStack item) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static int GetItemCount(Container inventory, Predicate<ItemStack> filter) {
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!filter.test(stack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static boolean RemoveItemCount(Container inventory, Item item, int count) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != item) continue;
            if (stack.getCount() > count) {
                stack.shrink(count);
                return true;
            }
            count -= stack.getCount();
            inventory.setItem(i, ItemStack.EMPTY);
        }
        return count <= 0;
    }

    public static boolean RemoveItemCount(Container inventory, ItemStack item) {
        if (InventoryUtil.GetItemCount(inventory, item) < item.getCount()) {
            return false;
        }
        int count = item.getCount();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.getCount());
            count -= amountToTake;
            if (amountToTake == stack.getCount()) {
                inventory.setItem(i, ItemStack.EMPTY);
                continue;
            }
            stack.shrink(amountToTake);
        }
        return true;
    }

    public static boolean RemoveItemCount(IItemHandler itemHandler, ItemStack item) {
        if (!InventoryUtil.CanExtractItem(itemHandler, item)) {
            return false;
        }
        int amountToRemove = item.getCount();
        for (int i = 0; i < itemHandler.getSlots() && amountToRemove > 0; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            ItemStack removedStack = itemHandler.extractItem(i, amountToRemove, false);
            if (InventoryUtil.ItemMatches(removedStack, item)) {
                amountToRemove -= removedStack.getCount();
                continue;
            }
            itemHandler.insertItem(i, removedStack, false);
        }
        return true;
    }

    public static boolean CanExtractItem(IItemHandler itemHandler, ItemStack item) {
        int amountToRemove = item.getCount();
        for (int i = 0; i < itemHandler.getSlots() && amountToRemove > 0; ++i) {
            ItemStack removedStack;
            if (!InventoryUtil.ItemMatches(itemHandler.getStackInSlot(i), item) || !InventoryUtil.ItemMatches(removedStack = itemHandler.extractItem(i, amountToRemove, true), item)) continue;
            amountToRemove -= removedStack.getCount();
        }
        return amountToRemove == 0;
    }

    public static int GetItemSpace(Container container, ItemStack item) {
        return InventoryUtil.GetItemSpace(container, item, 0, container.getContainerSize());
    }

    public static int GetItemSpace(Container container, ItemStack item, int startingIndex, int stopIndex) {
        int count = 0;
        for (int i = startingIndex; i < stopIndex && i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (InventoryUtil.ItemMatches(item, stack)) {
                count += stack.getMaxStackSize() - stack.getCount();
                continue;
            }
            if (!stack.isEmpty()) continue;
            count += stack.getMaxStackSize();
        }
        return count;
    }

    public static int GetItemTagCount(Container inventory, TagKey<Item> itemTag, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.getItem())) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static boolean RemoveItemTagCount(Container inventory, TagKey<Item> itemTag, int count, Item ... blacklistItems) {
        if (InventoryUtil.GetItemTagCount(inventory, itemTag, blacklistItems) < count) {
            return false;
        }
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.getItem())) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.getCount());
            count -= amountToTake;
            if (amountToTake == stack.getCount()) {
                inventory.setItem(i, ItemStack.EMPTY);
                continue;
            }
            stack.shrink(amountToTake);
        }
        return true;
    }

    public static boolean PutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.getCount();
        Item mergeItem = stack.getItem();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.getCount() == inventoryStack.getMaxStackSize()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.getMaxStackSize() - inventoryStack.getCount());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!inventoryStack.isEmpty()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.getMaxStackSize());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            ItemStack itemStack = inventory.getItem(((Integer)order.getFirst()).intValue());
            if (itemStack.isEmpty()) {
                ItemStack newStack = stack.copyWithCount(((Integer)order.getSecond()).intValue());
                inventory.setItem(((Integer)order.getFirst()).intValue(), newStack);
            } else {
                itemStack.setCount(itemStack.getCount() + (Integer)order.getSecond());
            }
        });
        return true;
    }

    public static ItemStack TryPutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.getCount();
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.getCount() >= inventoryStack.getMaxStackSize()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.getMaxStackSize() - inventoryStack.getCount());
            inventoryStack.grow(amountToPlace);
            inventory.setItem(i, inventoryStack);
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!inventoryStack.isEmpty()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.getMaxStackSize());
            ItemStack newStack = stack.copy();
            newStack.setCount(amountToPlace);
            inventory.setItem(i, newStack);
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            ItemStack leftovers = stack.copy();
            leftovers.setCount(amountToMerge);
            return leftovers;
        }
        return ItemStack.EMPTY;
    }

    public static boolean CanPutItemStack(Container inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        if (stack.isEmpty()) {
            return true;
        }
        int amountToMerge = stack.getCount();
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.getCount() == inventoryStack.getMaxStackSize()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.getMaxStackSize() - inventoryStack.getCount());
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.getContainerSize() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.getItem(i);
            if (!inventoryStack.isEmpty()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.getMaxStackSize());
            amountToMerge -= amountToPlace;
        }
        return amountToMerge <= 0;
    }

    public static boolean CanPutItemStacks(Container inventory, ItemStack ... stacks) {
        return InventoryUtil.CanPutItemStacks(inventory, Lists.newArrayList((Object[])stacks));
    }

    public static boolean CanPutItemStacks(Container inventory, List<ItemStack> stacks) {
        SimpleContainer copyInventory = new SimpleContainer(inventory.getContainerSize());
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            copyInventory.setItem(i, inventory.getItem(i).copy());
        }
        for (ItemStack stack : stacks) {
            if (InventoryUtil.PutItemStack((Container)copyInventory, stack)) continue;
            return false;
        }
        return true;
    }

    public static void MergeStacks(Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            int amountWanted;
            ItemStack thisStack = inventory.getItem(i);
            if (thisStack.isEmpty() || (amountWanted = thisStack.getMaxStackSize() - thisStack.getCount()) <= 0) continue;
            for (int j = i + 1; j < inventory.getContainerSize(); ++j) {
                ItemStack nextStack = inventory.getItem(j);
                if (nextStack.isEmpty() || nextStack.getItem() != thisStack.getItem() || !ItemStackHelper.TagEquals(thisStack, nextStack)) continue;
                while (amountWanted > 0 && !nextStack.isEmpty()) {
                    nextStack.setCount(nextStack.getCount() - 1);
                    thisStack.setCount(thisStack.getCount() + 1);
                    --amountWanted;
                }
            }
        }
    }

    public static void saveAllItems(String key, CompoundTag compound, Container inventory, HolderLookup.Provider lookup) {
        ItemStackHelper.saveAllItems(key, compound, InventoryUtil.buildList(inventory), lookup);
    }

    public static SimpleContainer loadAllItems(String key, CompoundTag compound, int inventorySize, HolderLookup.Provider lookup) {
        NonNullList tempInventory = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
        ItemStackHelper.loadAllItems(key, compound, (NonNullList<ItemStack>)tempInventory, lookup);
        return InventoryUtil.buildInventory((List<ItemStack>)tempInventory);
    }

    public static CompoundTag saveItemNoLimits(@Nonnull ItemStack stack, @Nonnull HolderLookup.Provider lookup) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        CompoundTag tag = (CompoundTag)stack.copyWithCount(1).save(lookup);
        tag.putInt("Count", stack.getCount());
        return tag;
    }

    public static ItemStack loadItemNoLimits(@Nonnull CompoundTag itemTag, @Nonnull HolderLookup.Provider lookup) {
        ItemStack result = ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)itemTag);
        if (!result.isEmpty() && itemTag.contains("Count")) {
            result.setCount(itemTag.getInt("Count"));
        }
        return result;
    }

    public static void encodeItems(Container inventory, RegistryFriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        InventoryUtil.saveAllItems("ITEMS", tag, inventory, (HolderLookup.Provider)buffer.registryAccess());
        buffer.writeInt(inventory.getContainerSize());
        buffer.writeNbt((Tag)tag);
    }

    public static SimpleContainer decodeItems(RegistryFriendlyByteBuf buffer) {
        int inventorySize = buffer.readInt();
        return InventoryUtil.loadAllItems("ITEMS", (CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()), inventorySize, (HolderLookup.Provider)buffer.registryAccess());
    }

    public static SimpleContainer copy(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.getContainerSize());
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            copy.setItem(i, inventory.getItem(i).copy());
        }
        return copy;
    }

    public static void dumpContents(Level level, BlockPos pos, Container inventory) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            InventoryUtil.dumpContents(level, pos, inventory.getItem(i));
        }
    }

    public static void dumpContents(Level level, BlockPos pos, List<ItemStack> inventory) {
        if (level.isClientSide) {
            return;
        }
        for (ItemStack itemStack : inventory) {
            InventoryUtil.dumpContents(level, pos, itemStack);
        }
    }

    public static void dumpContents(Level level, BlockPos pos, ItemStack stack) {
        if (level.isClientSide) {
            return;
        }
        if (!stack.isEmpty()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            level.addFreshEntity((Entity)entity);
        }
    }

    public static List<ItemStack> combineQueryItems(ItemStack ... items) {
        return InventoryUtil.combineQueryItems(Lists.newArrayList((Object[])items));
    }

    public static List<ItemStack> combineQueryItems(List<ItemStack> items) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            boolean addNew = true;
            for (int i = 0; i < itemList.size() && addNew; ++i) {
                ItemStack existingStack = (ItemStack)itemList.get(i);
                if (!InventoryUtil.ItemMatches(item, existingStack)) continue;
                existingStack.grow(item.getCount());
                addNew = false;
            }
            if (!addNew || item.isEmpty()) continue;
            itemList.add(item.copy());
        }
        return itemList;
    }

    public static List<ItemRequirement> combineRequirements(ItemRequirement ... requirements) {
        ArrayList<ItemRequirement> list = new ArrayList<ItemRequirement>();
        for (ItemRequirement requirement : requirements) {
            ItemRequirement r;
            if (requirement.isNull()) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !(r = (ItemRequirement)iterator.next()).tryMerge(requirement)) {
            }
            if (requirement.isNull()) continue;
            list.add(requirement);
        }
        return list;
    }

    public static boolean ItemMatches(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() == stack2.getItem()) {
            return ItemStackHelper.TagEquals(stack1, stack2);
        }
        return false;
    }

    public static boolean ItemsFullyMatch(ItemStack stack1, ItemStack stack2) {
        return InventoryUtil.ItemMatches(stack1, stack2) && stack1.getCount() == stack2.getCount();
    }

    public static boolean ContainerMatches(@Nonnull List<ItemStack> list1, @Nonnull List<ItemStack> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (InventoryUtil.ItemsFullyMatch(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean ContainerMatches(@Nonnull Container container1, @Nonnull Container container2) {
        if (container1.getContainerSize() != container2.getContainerSize()) {
            return false;
        }
        for (int i = 0; i < container1.getContainerSize(); ++i) {
            if (InventoryUtil.ItemsFullyMatch(container1.getItem(i), container2.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean ItemHasTag(ItemStack item, TagKey<Item> tag) {
        return item.getTags().anyMatch(t -> t.equals((Object)tag));
    }

    @Nonnull
    public static List<Item> GetItemsWithTag(@Nonnull TagKey<Item> tag) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(tag)) {
            result.add((Item)holder.value());
        }
        return result;
    }

    @Nonnull
    public static List<ItemStack> GetItemStacksWithTag(@Nonnull TagKey<Item> tag) {
        return InventoryUtil.GetItemsWithTag(tag).stream().map(ItemStack::new).toList();
    }

    public static int safeGiveToPlayer(Inventory inv, ItemStack stack) {
        int i = inv.getSlotWithRemainingSpace(stack);
        if (i == -1) {
            i = inv.getFreeSlot();
        }
        if (i >= 0) {
            ItemStack stackInSlot = inv.getItem(i);
            int putCount = Math.min(stack.getCount(), stackInSlot.isEmpty() ? stack.getMaxStackSize() : stackInSlot.getMaxStackSize() - stackInSlot.getCount());
            if (putCount > 0) {
                if (stackInSlot.isEmpty()) {
                    stackInSlot = stack.copy();
                    stackInSlot.setCount(putCount);
                } else {
                    stackInSlot.grow(putCount);
                }
                stack.shrink(putCount);
                inv.setItem(i, stackInSlot);
                inv.setChanged();
            }
            return putCount;
        }
        return 0;
    }

    public static int totalItemCount(@Nonnull List<ItemStack> list) {
        int count = 0;
        for (ItemStack s : list) {
            count += s.getCount();
        }
        return count;
    }
}

