/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class FileUtil {
    public static Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    @Nonnull
    public static JsonElement convertItemStack(@Nonnull ItemStack item, @Nonnull HolderLookup.Provider lookup) {
        JsonElement json = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)item.copyWithCount(1)).getOrThrow();
        json.getAsJsonObject().addProperty("count", (Number)item.getCount());
        return json;
    }

    @Nonnull
    public static ItemStack parseItemStack(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException {
        int count = GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1);
        if (count > 99) {
            json.addProperty("count", (Number)1);
            ItemStack result = (ItemStack)((Pair)ItemStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)json).getOrThrow(JsonSyntaxException::new)).getFirst();
            result.setCount(count);
            return result;
        }
        return (ItemStack)((Pair)ItemStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup), (Object)json).getOrThrow(JsonSyntaxException::new)).getFirst();
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);
        writer.print(string);
        writer.close();
    }
}

